/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sbr;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Stash;
import akka.actor.StashSupport;
import akka.actor.SupervisorStrategy;
import akka.actor.TimerScheduler;
import akka.actor.TimerSchedulerImpl;
import akka.actor.Timers;
import akka.actor.UnrestrictedStash;
import akka.annotation.InternalApi;
import akka.annotation.InternalStableApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterLogMarker$;
import akka.cluster.Member;
import akka.cluster.Reachability;
import akka.cluster.UniqueAddress;
import akka.cluster.UniqueAddress$;
import akka.cluster.sbr.DowningStrategy;
import akka.cluster.sbr.DowningStrategy$DownAll$;
import akka.cluster.sbr.DowningStrategy$DownSelfQuarantinedByRemote$;
import akka.cluster.sbr.LeaseMajority;
import akka.cluster.sbr.SplitBrainResolver;
import akka.cluster.sbr.SplitBrainResolver$AcquireLease$;
import akka.cluster.sbr.SplitBrainResolver$ReleaseLeaseCondition$NoLease$;
import akka.cluster.sbr.SplitBrainResolver$Tick$;
import akka.cluster.sbr.SplitBrainResolverSettings;
import akka.cluster.sbr.StaticQuorum;
import akka.coordination.lease.scaladsl.Lease;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.event.DiagnosticMarkerBusLoggingAdapter;
import akka.event.Logging$;
import akka.remote.artery.ThisActorSystemQuarantinedEvent;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-hAB!C\u0003\u0003\u0011\u0005\n\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003^\u0011!)\u0007A!A!\u0002\u00131\u0007\"\u00026\u0001\t\u0003Y\u0007bB8\u0001\u0005\u0004%\t\u0001\u001d\u0005\u0007o\u0002\u0001\u000b\u0011B9\t\u000ba\u0004A\u0011A=\t\u000f\u0005\r\u0001A\"\u0001\u0002\u0006!9\u0011\u0011\u0003\u0001\u0007\u0002\u0005M\u0001bBA\u0019\u0001\u0019\u0005\u00111\u0007\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0017\u0001A\u0003%\u0011Q\u000b\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t\t\u0007\u0001C\u0005\u0003?Bq!a\u0019\u0001\t\u0003\ty\u0006C\u0005\u0002f\u0001\u0001\r\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001A\u0002\u0013\u0005\u0011\u0011\u000f\u0005\t\u0003o\u0002\u0001\u0015)\u0003\u0002j!I\u0011\u0011\u0010\u0001A\u0002\u0013\u0005\u0011q\r\u0005\n\u0003w\u0002\u0001\u0019!C\u0001\u0003{B\u0001\"!!\u0001A\u0003&\u0011\u0011\u000e\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\ty\t\u0001C\t\u0003#C1\"!'\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001c\"Y\u0011Q\u0014\u0001A\u0002\u0003\u0007I\u0011AAP\u0011-\t\u0019\u000b\u0001a\u0001\u0002\u0003\u0006K!a%\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"I\u0011\u0011\u0016\u0001A\u0002\u0013%\u00111\u0016\u0005\n\u0003w\u0003\u0001\u0019!C\u0005\u0003{C\u0001\"!1\u0001A\u0003&\u0011Q\u0016\u0005\b\u0003\u0007\u0004A\u0011BAT\u0011\u001d\t)\r\u0001C\u0005\u0003OC\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0013\u0005E\u0007\u00011A\u0005\n\u0005M\u0007\u0002CAl\u0001\u0001\u0006K!a3\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\b\"CAz\u0001\u0001\u0007I\u0011BA{\u0011%\u00119\u0001\u0001a\u0001\n\u0013\u0011I\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0015BA|\u0011\u001d\u0011y\u0001\u0001C!\u0003OCqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u000f\tE\u0002\u0001\"\u0003\u0002(\"9!1\u0007\u0001\u0005\n\tU\u0002b\u0002B#\u0001\u0011%\u0011q\u0015\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005+BqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t}\u0004\u0001\"\u0001\u0002h!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BH\u0001\u0011\u0005!\u0011\u0013\u0005\t\u0005+\u0003A\u0011\u0001\"\u0003\u0018\"9!1\u0015\u0001\u0005\n\u0005\u001d\u0006b\u0002BS\u0001\u0011\u0005!q\u0015\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005kCqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003D\u0002!\tA!2\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bk\u0001\u0011\u0005!q\u001b\u0005\b\u00057\u0004A\u0011\u0001Bo\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0003O\u0013ac\u00159mSR\u0014%/Y5o%\u0016\u001cx\u000e\u001c<fe\n\u000b7/\u001a\u0006\u0003\u0007\u0012\u000b1a\u001d2s\u0015\t)e)A\u0004dYV\u001cH/\u001a:\u000b\u0003\u001d\u000bA!Y6lCN)\u0001!S(V1B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\u0004\"\u0001U*\u000e\u0003ES!A\u0015$\u0002\u000b\u0005\u001cGo\u001c:\n\u0005Q\u000b&!B!di>\u0014\bC\u0001)W\u0013\t9\u0016KA\u0003Ti\u0006\u001c\b\u000e\u0005\u0002Q3&\u0011!,\u0015\u0002\u0007)&lWM]:\u0002\u0017M$\u0018M\u00197f\u0003\u001a$XM]\u0002\u0001!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005ekJ\fG/[8o\u0015\t\u00117*\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Z0\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006Iql\u001d;sCR,w-\u001f\t\u0003O\"l\u0011AQ\u0005\u0003S\n\u0013q\u0002R8x]&twm\u0015;sCR,w-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071lg\u000e\u0005\u0002h\u0001!)1l\u0001a\u0001;\")Qm\u0001a\u0001M\u0006\u0019An\\4\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001\u001e$\u0002\u000b\u00154XM\u001c;\n\u0005Y\u001c(!\t#jC\u001etwn\u001d;jG6\u000b'o[3s\u0005V\u001cHj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0001b\u001d;sCR,w-_\u000b\u0002M\"\u0012aa\u001f\t\u0003y~l\u0011! \u0006\u0003}\u001a\u000b!\"\u00198o_R\fG/[8o\u0013\r\t\t! \u0002\u0012\u0013:$XM\u001d8bYN#\u0018M\u00197f\u0003BL\u0017!E:fY\u001a,f.[9vK\u0006#GM]3tgV\u0011\u0011q\u0001\t\u0005\u0003\u0013\tY!D\u0001E\u0013\r\ti\u0001\u0012\u0002\u000e+:L\u0017/^3BI\u0012\u0014Xm]:)\u0005\u001dY\u0018AB:fY\u001a$5-\u0006\u0002\u0002\u0016A!\u0011qCA\u0016\u001d\u0011\tI\"a\n\u000f\t\u0005m\u0011Q\u0005\b\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005/\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015BA#G\u0013\r\tI\u0003R\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u0011QFA\u0018\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u0003S!\u0015\u0001\u00023po:$b!!\u000e\u0002<\u0005}\u0002c\u0001&\u00028%\u0019\u0011\u0011H&\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003{I\u0001\u0019AA\u0004\u0003\u0011qw\u000eZ3\t\u000f\u0005\u0005\u0013\u00021\u0001\u0002D\u0005AA-Z2jg&|g\u000e\u0005\u0003\u0002F\u0005-cbA4\u0002H%\u0019\u0011\u0011\n\"\u0002\u001f\u0011{wO\\5oON#(/\u0019;fOfLA!!\u0014\u0002P\tAA)Z2jg&|gNC\u0002\u0002J\t\u000b\u0001b]3ui&twm]\u000b\u0003\u0003+\u00022aZA,\u0013\r\tIF\u0011\u0002\u001b'Bd\u0017\u000e\u001e\"sC&t'+Z:pYZ,'oU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n1\u0003Z8x]\u0006cGn\u00165f]Vs7\u000f^1cY\u0016,\u0012!X\u0001\u0012e\u0016dW-Y:f\u0019\u0016\f7/Z!gi\u0016\u0014\u0018\u0001\u0004;jG.Le\u000e^3sm\u0006d\u0017A\u00027fC\u0012,'/\u0006\u0002\u0002jA\u0019!*a\u001b\n\u0007\u000554JA\u0004C_>dW-\u00198\u0002\u00151,\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005M\u0004\"CA;!\u0005\u0005\t\u0019AA5\u0003\rAH%M\u0001\bY\u0016\fG-\u001a:!\u0003=\u0019X\r\u001c4NK6\u0014WM]!eI\u0016$\u0017aE:fY\u001alU-\u001c2fe\u0006#G-\u001a3`I\u0015\fH\u0003BA\u001b\u0003\u007fB\u0011\"!\u001e\u0014\u0003\u0003\u0005\r!!\u001b\u0002!M,GNZ'f[\n,'/\u00113eK\u0012\u0004\u0013AE5oi\u0016\u0014h.\u00197ESN\u0004\u0018\r^2iKJ,\"!a\"\u0011\t\u0005%\u00151R\u0007\u0002C&\u0019\u0011QR1\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!\u00058foN#\u0018M\u00197f\t\u0016\fG\r\\5oKR\u0011\u00111\u0013\t\u0004=\u0006U\u0015bAAL?\nAA)Z1eY&tW-\u0001\bti\u0006\u0014G.\u001a#fC\u0012d\u0017N\\3\u0016\u0005\u0005M\u0015AE:uC\ndW\rR3bI2Lg.Z0%KF$B!!\u000e\u0002\"\"I\u0011Q\u000f\r\u0002\u0002\u0003\u0007\u00111S\u0001\u0010gR\f'\r\\3EK\u0006$G.\u001b8fA\u0005\u0019\"/Z:fiN#\u0018M\u00197f\t\u0016\fG\r\\5oKR\u0011\u0011QG\u0001\u0019e\u0016\f7\r[1cS2LG/_\"iC:<W\rZ*uCR\u001cXCAAW!\u0011\ty+!.\u000f\u0007\u001d\f\t,C\u0002\u00024\n\u000b!c\u00159mSR\u0014%/Y5o%\u0016\u001cx\u000e\u001c<fe&!\u0011qWA]\u0005a\u0011V-Y2iC\nLG.\u001b;z\u0007\"\fgnZ3e'R\fGo\u001d\u0006\u0004\u0003g\u0013\u0015\u0001\b:fC\u000eD\u0017MY5mSRL8\t[1oO\u0016$7\u000b^1ug~#S-\u001d\u000b\u0005\u0003k\ty\fC\u0005\u0002vq\t\t\u00111\u0001\u0002.\u0006I\"/Z1dQ\u0006\u0014\u0017\u000e\\5us\u000eC\u0017M\\4fIN#\u0018\r^:!\u0003u\u0011Xm]3u%\u0016\f7\r[1cS2LG/_\"iC:<W\rZ*uCR\u001c\u0018a\r:fg\u0016$(+Z1dQ\u0006\u0014\u0017\u000e\\5us\u000eC\u0017M\\4fIN#\u0018\r^:JM\u0006cG.\u00168sK\u0006\u001c\u0007.\u00192mK\u0012{wO\\3e\u0003U\u0011X\r\\3bg\u0016dU-Y:f\u0007>tG-\u001b;j_:,\"!a3\u0011\t\u0005=\u0016QZ\u0005\u0005\u0003\u001f\fILA\u000bSK2,\u0017m]3MK\u0006\u001cXmQ8oI&$\u0018n\u001c8\u00023I,G.Z1tK2+\u0017m]3D_:$\u0017\u000e^5p]~#S-\u001d\u000b\u0005\u0003k\t)\u000eC\u0005\u0002v\u0005\n\t\u00111\u0001\u0002L\u00061\"/\u001a7fCN,G*Z1tK\u000e{g\u000eZ5uS>t\u0007%\u0001\tnkR\fG/Z'f[\n,'/\u00138g_R!\u0011Q\\Au)\u0011\t)$a8\t\u000f\u0005\u00058\u00051\u0001\u0002d\u0006\ta\rE\u0003K\u0003K\f)$C\u0002\u0002h.\u0013\u0011BR;oGRLwN\u001c\u0019\t\u000f\u0005-8\u00051\u0001\u0002j\u0005Y!/Z:fiN#\u0018M\u00197f\u0003aiW\u000f^1uKJ+7\u000f]8og&\u0014\u0017\u000e\\5us&sgm\u001c\u000b\u0005\u0003k\t\t\u0010C\u0004\u0002b\u0012\u0002\r!a9\u0002-Ut'/Z1dQ\u0006\u0014G.\u001a#bi\u0006\u001cUM\u001c;feN,\"!a>\u0011\r\u0005e(1AA\u000b\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018!C5n[V$\u0018M\u00197f\u0015\r\u0011\taS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0003\u0003w\u00141aU3u\u0003i)hN]3bG\"\f'\r\\3ECR\f7)\u001a8uKJ\u001cx\fJ3r)\u0011\t)Da\u0003\t\u0013\u0005Ud%!AA\u0002\u0005]\u0018aF;oe\u0016\f7\r[1cY\u0016$\u0015\r^1DK:$XM]:!\u0003!\u0001xn\u001d;Ti>\u0004\u0018a\u0002:fG\u0016Lg/Z\u000b\u0003\u0005+\u0001BAa\u0006\u0003\u001a5\t\u0001!C\u0002\u0003\u001cM\u0013qAU3dK&4X-A\u0007mK\u0006$WM]\"iC:<W\r\u001a\u000b\u0005\u0003k\u0011\t\u0003C\u0004\u0003$)\u0002\rA!\n\u0002\u00191,\u0017\rZ3s\u001fB$\u0018n\u001c8\u0011\u000b)\u00139Ca\u000b\n\u0007\t%2J\u0001\u0004PaRLwN\u001c\t\u0004!\n5\u0012b\u0001B\u0018#\n9\u0011\t\u001a3sKN\u001c\u0018\u0001\u0002;jG.\fQ\u0004\u001e5jg\u0006\u001bGo\u001c:TsN$X-\\,bgF+\u0018M]1oi&tW\r\u001a\u000b\u0005\u0003k\u00119\u0004C\u0004\u0003:1\u0002\rAa\u000f\u0002\u0019I,Wn\u001c;f+:L\u0017/^3\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQ1A!\u0011G\u0003\u0019\u0011X-\\8uK&!\u0011Q\u0002B \u00031\t7-];je\u0016dU-Y:f\u0003=9\u0018-\u001b;j]\u001e4uN\u001d'fCN,G\u0003\u0002B\u000b\u0005\u0017Bq!!\u0011/\u0001\u0004\u0011i\u0005\u0005\u0003\u0002F\t=\u0013\u0002\u0002B)\u0003\u001f\u0012A#Q2rk&\u0014X\rT3bg\u0016$UmY5tS>t\u0017A\u0005:fY\u0016\f7/\u001a'fCN,'+Z:vYR$B!!\u000e\u0003X!9!\u0011L\u0018A\u0002\u0005%\u0014\u0001\u0003:fY\u0016\f7/\u001a3\u0002\u001b\u0005\u001cGo\u00148EK\u000eL7/[8o)\u0011\u0011yF!\u001c\u0011\r\t\u0005$\u0011NA\u0004\u001d\u0011\u0011\u0019G!\u001a\u0011\u0007\u0005u1*C\u0002\u0003h-\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0003\u0005WR1Aa\u001aL\u0011\u001d\t\t\u0005\ra\u0001\u0003\u0007\nqb\u001c2tKJ4X\rR3dSNLwN\u001c\u000b\t\u0003k\u0011\u0019H!\u001e\u0003z!9\u0011\u0011I\u0019A\u0002\u0005\r\u0003b\u0002B<c\u0001\u0007!qL\u0001\f]>$Wm\u001d+p\t><h\u000eC\u0004\u0002tF\u0002\rAa\u001f\u0011\r\t\u0005$\u0011NA\u000bQ\t\t40A\u0007jgJ+7\u000f]8og&\u0014G.Z\u0001\u0012k:\u0014X-Y2iC\ndW-T3nE\u0016\u0014H\u0003BA\u001b\u0005\u000bCqAa\"4\u0001\u0004\u0011I)A\u0001n!\u0011\tIAa#\n\u0007\t5EI\u0001\u0004NK6\u0014WM]\u0001\u0010e\u0016\f7\r[1cY\u0016lU-\u001c2feR!\u0011Q\u0007BJ\u0011\u001d\u00119\t\u000ea\u0001\u0005\u0013\u000b1C]3bG\"\f'-\u001b7jif\u001c\u0005.\u00198hK\u0012$B!!\u000e\u0003\u001a\"9!1T\u001bA\u0002\tu\u0015!\u0001:\u0011\t\u0005%!qT\u0005\u0004\u0005C#%\u0001\u0004*fC\u000eD\u0017MY5mSRL\u0018AH;qI\u0006$XMU3bG\"\f'-\u001b7jif\u001c\u0005.\u00198hK\u0012\u001cF/\u0019;t\u0003U)hN]3bG\"\f'\r\\3ECR\f7)\u001a8uKJ$B!!\u000e\u0003*\"9!1V\u001cA\u0002\u0005U\u0011A\u00013d\u0003M\u0011X-Y2iC\ndW\rR1uC\u000e+g\u000e^3s)\u0011\t)D!-\t\u000f\t-\u0006\b1\u0001\u0002\u0016\u0005Y1/Z3o\u0007\"\fgnZ3e)\u0011\t)Da.\t\u000f\te\u0016\b1\u0001\u0003<\u000611/Z3o\u0005f\u0004bA!\u0019\u0003j\t-\u0012!B1eIV\u0003H\u0003BA\u001b\u0005\u0003DqAa\";\u0001\u0004\u0011I)A\u0004mK\u00064\u0018N\\4\u0015\t\u0005U\"q\u0019\u0005\b\u0005\u000f[\u0004\u0019\u0001BE\u0003\u0019)\u00070\u001b;fIR!\u0011Q\u0007Bg\u0011\u001d\u00119\t\u0010a\u0001\u0005\u0013\u000b!\"\u00193e\u0015>Lg.\u001b8h)\u0011\t)Da5\t\u000f\t\u001dU\b1\u0001\u0003\n\u0006Y\u0011\r\u001a3XK\u0006\\G._+q)\u0011\t)D!7\t\u000f\t\u001de\b1\u0001\u0003\n\u00061!/Z7pm\u0016$B!!\u000e\u0003`\"9!qQ A\u0002\t%\u0015\u0001\u0004:fY\u0016\f7/\u001a'fCN,\u0007f\u0001\u0001\u0003fB\u0019APa:\n\u0007\t%XPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public abstract class SplitBrainResolverBase
implements Stash,
Timers {
    private final FiniteDuration stableAfter;
    private final DowningStrategy _strategy;
    private final DiagnosticMarkerBusLoggingAdapter log;
    private final SplitBrainResolverSettings settings;
    private boolean leader;
    private boolean selfMemberAdded;
    private Deadline stableDeadline;
    private SplitBrainResolver.ReachabilityChangedStats reachabilityChangedStats;
    private SplitBrainResolver.ReleaseLeaseCondition akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
    private Set<String> unreachableDataCenters;
    private TimerSchedulerImpl akka$actor$Timers$$_timers;
    private Vector<Envelope> akka$actor$StashSupport$$theStash;
    private int akka$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private ActorContext context;
    private ActorRef self;

    public /* synthetic */ void akka$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void akka$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void akka$actor$Timers$$super$aroundReceive(PartialFunction receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive2, (Object)msg);
    }

    public final TimerScheduler timers() {
        return Timers.timers$((Timers)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Timers.aroundPreRestart$((Timers)this, (Throwable)reason, message);
    }

    public void aroundPostStop() {
        Timers.aroundPostStop$((Timers)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Timers.aroundReceive$((Timers)this, receive2, (Object)msg);
    }

    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        UnrestrictedStash.preRestart$((UnrestrictedStash)this, (Throwable)reason, message);
    }

    public void stash() {
        StashSupport.stash$((StashSupport)this);
    }

    public void prepend(Seq<Envelope> others) {
        StashSupport.prepend$((StashSupport)this, others);
    }

    public void unstash() {
        StashSupport.unstash$((StashSupport)this);
    }

    public void unstashAll() {
        StashSupport.unstashAll$((StashSupport)this);
    }

    @InternalStableApi
    public void unstashAll(Function1<Object, Object> filterPredicate) {
        StashSupport.unstashAll$((StashSupport)this, filterPredicate);
    }

    @InternalStableApi
    public Vector<Envelope> clearStash() {
        return StashSupport.clearStash$((StashSupport)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public TimerSchedulerImpl akka$actor$Timers$$_timers() {
        return this.akka$actor$Timers$$_timers;
    }

    public final void akka$actor$Timers$_setter_$akka$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$1) {
        this.akka$actor$Timers$$_timers = x$1;
    }

    public Vector<Envelope> akka$actor$StashSupport$$theStash() {
        return this.akka$actor$StashSupport$$theStash;
    }

    public void akka$actor$StashSupport$$theStash_$eq(Vector<Envelope> x$1) {
        this.akka$actor$StashSupport$$theStash = x$1;
    }

    public int akka$actor$StashSupport$$capacity() {
        return this.akka$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public final void akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq(int x$1) {
        this.akka$actor$StashSupport$$capacity = x$1;
    }

    public void akka$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$1) {
        this.mailbox = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public DiagnosticMarkerBusLoggingAdapter log() {
        return this.log;
    }

    @InternalStableApi
    public DowningStrategy strategy() {
        return this._strategy;
    }

    @InternalStableApi
    public abstract UniqueAddress selfUniqueAddress();

    public abstract String selfDc();

    public abstract void down(UniqueAddress var1, DowningStrategy.Decision var2);

    private SplitBrainResolverSettings settings() {
        return this.settings;
    }

    public FiniteDuration downAllWhenUnstable() {
        return this.settings().DownAllWhenUnstable();
    }

    public FiniteDuration akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter() {
        DowningStrategy downingStrategy = this.strategy();
        if (!(downingStrategy instanceof LeaseMajority)) {
            throw new IllegalStateException(new StringBuilder(51).append("Unexpected use of releaseLeaseAfter for strategy [").append(downingStrategy.getClass().getName()).append("]").toString());
        }
        LeaseMajority leaseMajority = (LeaseMajority)downingStrategy;
        FiniteDuration finiteDuration = leaseMajority.releaseAfter();
        return finiteDuration;
    }

    public FiniteDuration tickInterval() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }

    public boolean leader() {
        return this.leader;
    }

    public void leader_$eq(boolean x$1) {
        this.leader = x$1;
    }

    public boolean selfMemberAdded() {
        return this.selfMemberAdded;
    }

    public void selfMemberAdded_$eq(boolean x$1) {
        this.selfMemberAdded = x$1;
    }

    private ExecutionContext internalDispatcher() {
        return ((ExtendedActorSystem)this.context().system()).dispatchers().internalDispatcher();
    }

    public Deadline newStableDeadline() {
        return Deadline$.MODULE$.now().$plus(this.stableAfter);
    }

    public Deadline stableDeadline() {
        return this.stableDeadline;
    }

    public void stableDeadline_$eq(Deadline x$1) {
        this.stableDeadline = x$1;
    }

    public void resetStableDeadline() {
        this.stableDeadline_$eq(this.newStableDeadline());
    }

    private SplitBrainResolver.ReachabilityChangedStats reachabilityChangedStats() {
        return this.reachabilityChangedStats;
    }

    private void reachabilityChangedStats_$eq(SplitBrainResolver.ReachabilityChangedStats x$1) {
        this.reachabilityChangedStats = x$1;
    }

    private void resetReachabilityChangedStats() {
        long now = System.nanoTime();
        this.reachabilityChangedStats_$eq(new SplitBrainResolver.ReachabilityChangedStats(now, now, 0L));
    }

    private void resetReachabilityChangedStatsIfAllUnreachableDowned() {
        block0: {
            if (this.reachabilityChangedStats().isEmpty() || !this.strategy().isAllUnreachableDownOrExiting()) break block0;
            this.log().debug("SBR resetting reachability stats, after all unreachable healed, downed or removed");
            this.resetReachabilityChangedStats();
        }
    }

    public SplitBrainResolver.ReleaseLeaseCondition akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition() {
        return this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition_$eq(SplitBrainResolver.ReleaseLeaseCondition x$1) {
        this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = x$1;
    }

    public void mutateMemberInfo(boolean resetStable, Function0<BoxedUnit> f) {
        block6: {
            int unreachableBefore = this.strategy().unreachable().size();
            f.apply$mcV$sp();
            int unreachableAfter = this.strategy().unreachable().size();
            if (!resetStable) break block6;
            if (this.isResponsible()) {
                if (unreachableBefore == 0 && unreachableAfter > 0) {
                    this.log().info("SBR found unreachable members, waiting for stable-after = {} ms before taking downing decision. Now {} unreachable members found. Downing decision will not be made before {}.", (Object)BoxesRunTime.boxToLong((long)this.stableAfter.toMillis()), (Object)BoxesRunTime.boxToInteger((int)unreachableAfter), (Object)this.earliestTimeOfDecision$1());
                } else if (unreachableBefore > 0 && unreachableAfter == 0) {
                    this.log().info("SBR found all unreachable members healed during stable-after period, no downing decision necessary for now.");
                } else if (unreachableAfter > 0) {
                    this.log().info("SBR found unreachable members changed during stable-after period. Resetting timer. Now {} unreachable members found. Downing decision will not be made before {}.", (Object)BoxesRunTime.boxToInteger((int)unreachableAfter), (Object)this.earliestTimeOfDecision$1());
                }
            }
            this.log().debug("SBR reset stable deadline when members/unreachable changed");
            this.resetStableDeadline();
        }
    }

    public void mutateResponsibilityInfo(Function0<BoxedUnit> f) {
        block3: {
            boolean responsibleBefore = this.isResponsible();
            f.apply$mcV$sp();
            boolean responsibleAfter = this.isResponsible();
            if (!responsibleBefore && responsibleAfter) {
                this.log().info("This node is now the leader responsible for taking SBR decisions among the reachable nodes (more leaders may exist).");
            } else if (responsibleBefore && !responsibleAfter) {
                this.log().info("This node is not the leader any more and not responsible for taking SBR decisions.");
            }
            if (!this.leader() || this.selfMemberAdded()) break block3;
            this.log().debug("This node is leader but !selfMemberAdded.");
        }
    }

    private Set<String> unreachableDataCenters() {
        return this.unreachableDataCenters;
    }

    private void unreachableDataCenters_$eq(Set<String> x$1) {
        this.unreachableDataCenters = x$1;
    }

    public void postStop() {
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
        SplitBrainResolver$ReleaseLeaseCondition$NoLease$ splitBrainResolver$ReleaseLeaseCondition$NoLease$ = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
        if (releaseLeaseCondition == null ? splitBrainResolver$ReleaseLeaseCondition$NoLease$ != null : !releaseLeaseCondition.equals(splitBrainResolver$ReleaseLeaseCondition$NoLease$)) {
            this.log().info("SBR is stopped and owns the lease. The lease will not be released until after the lease heartbeat-timeout.");
        }
        UnrestrictedStash.postStop$((UnrestrictedStash)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitBrainResolverBase $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.SeenChanged) {
                    ClusterEvent.SeenChanged seenChanged = (ClusterEvent.SeenChanged)A1;
                    Set<Address> seenBy = seenChanged.seenBy();
                    this.$outer.seenChanged(seenBy);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberJoined) {
                    ClusterEvent.MemberJoined memberJoined = (ClusterEvent.MemberJoined)A1;
                    Member m = memberJoined.member();
                    this.$outer.addJoining(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberWeaklyUp) {
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = (ClusterEvent.MemberWeaklyUp)A1;
                    Member m = memberWeaklyUp.member();
                    this.$outer.addWeaklyUp(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                    Member m = memberUp.member();
                    this.$outer.addUp(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberLeft) {
                    ClusterEvent.MemberLeft memberLeft = (ClusterEvent.MemberLeft)A1;
                    Member m = memberLeft.member();
                    this.$outer.leaving(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberExited) {
                    ClusterEvent.MemberExited memberExited = (ClusterEvent.MemberExited)A1;
                    Member m = memberExited.member();
                    this.$outer.exited(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberDowned) {
                    ClusterEvent.MemberDowned memberDowned = (ClusterEvent.MemberDowned)A1;
                    Member m = memberDowned.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachabilityChanged) {
                    ClusterEvent.ReachabilityChanged reachabilityChanged = (ClusterEvent.ReachabilityChanged)A1;
                    Reachability r = reachabilityChanged.reachability();
                    this.$outer.reachabilityChanged(r);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.remove(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableDataCenter) {
                    ClusterEvent.UnreachableDataCenter unreachableDataCenter = (ClusterEvent.UnreachableDataCenter)A1;
                    String dc = unreachableDataCenter.dataCenter();
                    this.$outer.unreachableDataCenter(dc);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableDataCenter) {
                    ClusterEvent.ReachableDataCenter reachableDataCenter = (ClusterEvent.ReachableDataCenter)A1;
                    String dc = reachableDataCenter.dataCenter();
                    this.$outer.reachableDataCenter(dc);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.LeaderChanged) {
                    ClusterEvent.LeaderChanged leaderChanged = (ClusterEvent.LeaderChanged)A1;
                    Option<Address> leaderOption = leaderChanged.leader();
                    this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$leaderChanged(leaderOption);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof SplitBrainResolver.ReleaseLeaseResult) {
                    SplitBrainResolver.ReleaseLeaseResult releaseLeaseResult = (SplitBrainResolver.ReleaseLeaseResult)A1;
                    boolean released = releaseLeaseResult.released();
                    this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseResult(released);
                    object = BoxedUnit.UNIT;
                } else if (SplitBrainResolver$Tick$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$tick();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ThisActorSystemQuarantinedEvent) {
                    ThisActorSystemQuarantinedEvent thisActorSystemQuarantinedEvent = (ThisActorSystemQuarantinedEvent)A1;
                    akka.remote.UniqueAddress remote = thisActorSystemQuarantinedEvent.remoteAddress();
                    this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$thisActorSystemWasQuarantined(remote);
                    object = BoxedUnit.UNIT;
                } else {
                    object = A1 instanceof ClusterEvent.ClusterDomainEvent ? BoxedUnit.UNIT : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.SeenChanged ? true : (object instanceof ClusterEvent.MemberJoined ? true : (object instanceof ClusterEvent.MemberWeaklyUp ? true : (object instanceof ClusterEvent.MemberUp ? true : (object instanceof ClusterEvent.MemberLeft ? true : (object instanceof ClusterEvent.MemberExited ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.MemberDowned ? true : (object instanceof ClusterEvent.ReachableMember ? true : (object instanceof ClusterEvent.ReachabilityChanged ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.UnreachableDataCenter ? true : (object instanceof ClusterEvent.ReachableDataCenter ? true : (object instanceof ClusterEvent.LeaderChanged ? true : (object instanceof SplitBrainResolver.ReleaseLeaseResult ? true : (SplitBrainResolver$Tick$.MODULE$.equals(object) ? true : (object instanceof ThisActorSystemQuarantinedEvent ? true : object instanceof ClusterEvent.ClusterDomainEvent))))))))))))))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$leaderChanged(Option<Address> leaderOption) {
        this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.leader_$eq(leaderOption.contains((Object)this.selfUniqueAddress().address())));
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$tick() {
        Set<UniqueAddress> set;
        Set<UniqueAddress> set2;
        if (this.reachabilityChangedStats().changeCount() > 0L) {
            long now = System.nanoTime();
            FiniteDuration durationSinceLatestChange = new package.DurationLong(package$.MODULE$.DurationLong(now - this.reachabilityChangedStats().latestChangeTimestamp())).nanos();
            FiniteDuration durationSinceFirstChange = new package.DurationLong(package$.MODULE$.DurationLong(now - this.reachabilityChangedStats().firstChangeTimestamp())).nanos();
            boolean downAllWhenUnstableEnabled = this.downAllWhenUnstable().$greater((Object)Duration$.MODULE$.Zero());
            if (downAllWhenUnstableEnabled && durationSinceFirstChange.$greater((Object)this.stableAfter.$plus(this.downAllWhenUnstable()))) {
                this.log().warning(ClusterLogMarker$.MODULE$.sbrInstability(), "SBR detected instability and will down all nodes: {}", (Object)this.reachabilityChangedStats());
                set2 = this.actOnDecision(DowningStrategy$DownAll$.MODULE$);
            } else {
                if (!downAllWhenUnstableEnabled && durationSinceLatestChange.$greater((Object)this.stableAfter.$times(2L))) {
                    this.log().debug("SBR no reachability changes within {} ms, resetting stats", (Object)BoxesRunTime.boxToLong((long)this.stableAfter.$times(2L).toMillis()));
                    this.resetReachabilityChangedStats();
                }
                set2 = BoxedUnit.UNIT;
            }
        } else {
            set2 = BoxedUnit.UNIT;
        }
        if (this.isResponsible() && this.strategy().unreachable().nonEmpty() && this.stableDeadline().isOverdue()) {
            Set<UniqueAddress> set3;
            DowningStrategy.Decision decision = this.strategy().decide();
            if (decision instanceof DowningStrategy.AcquireLeaseDecision) {
                BoxedUnit boxedUnit;
                DowningStrategy.AcquireLeaseDecision acquireLeaseDecision = (DowningStrategy.AcquireLeaseDecision)decision;
                Option<Lease> option = this.strategy().lease();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Lease lease = (Lease)some.value();
                    if (lease.checkLease()) {
                        this.log().info(ClusterLogMarker$.MODULE$.sbrLeaseAcquired(acquireLeaseDecision), "SBR has acquired lease for decision [{}]", (Object)acquireLeaseDecision);
                        boxedUnit = this.actOnDecision(acquireLeaseDecision);
                    } else {
                        FiniteDuration finiteDuration = acquireLeaseDecision.acquireDelay();
                        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                        if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                            this.akka$cluster$sbr$SplitBrainResolverBase$$acquireLease();
                        } else {
                            this.log().debug("SBR delayed attempt to acquire lease for [{} ms]", (Object)BoxesRunTime.boxToLong((long)acquireLeaseDecision.acquireDelay().toMillis()));
                            this.timers().startSingleTimer((Object)SplitBrainResolver$AcquireLease$.MODULE$, (Object)SplitBrainResolver$AcquireLease$.MODULE$, acquireLeaseDecision.acquireDelay());
                        }
                        this.context().become(this.waitingForLease(acquireLeaseDecision));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException("Unexpected lease decision although lease is not configured");
                    }
                    throw new MatchError(option);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                set3 = boxedUnit2;
            } else {
                set3 = this.actOnDecision(decision);
            }
            set = set3;
        } else {
            set = BoxedUnit.UNIT;
        }
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
        if (releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed) {
            BoxedUnit boxedUnit;
            SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed whenTimeElapsed = (SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed)releaseLeaseCondition;
            Deadline deadline = whenTimeElapsed.deadline();
            if (deadline.isOverdue()) {
                this.releaseLease();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$thisActorSystemWasQuarantined(akka.remote.UniqueAddress remoteUnique) {
        UniqueAddress remote = UniqueAddress$.MODULE$.apply(remoteUnique.address(), remoteUnique.uid());
        if (((Cluster)Cluster$.MODULE$.apply(this.context().system())).state().members().exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)SplitBrainResolverBase.$anonfun$thisActorSystemWasQuarantined$1(remote, m)))) {
            this.actOnDecision(DowningStrategy$DownSelfQuarantinedByRemote$.MODULE$);
        } else {
            this.log().debug("Remote [{}] quarantined this system but is not part of cluster, ignoring", (Object)remote);
        }
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$acquireLease() {
        this.log().debug("SBR trying to acquire lease");
        ExecutionContext ec = this.internalDispatcher();
        this.strategy().lease().foreach((Function1 & Serializable)x$2 -> akka.pattern.package$.MODULE$.pipe(x$2.acquire().recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitBrainResolverBase $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.log().error(A1, "SBR acquire of lease failed");
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ec).map((Function1 & Serializable)holdingLease -> SplitBrainResolverBase.$anonfun$acquireLease$2(BoxesRunTime.unboxToBoolean((Object)holdingLease)), ec), ec).pipeTo(this.self(), this.self()));
    }

    public PartialFunction<Object, BoxedUnit> waitingForLease(DowningStrategy.AcquireLeaseDecision decision) {
        return new Serializable(this, decision){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitBrainResolverBase $outer;
            private final DowningStrategy.AcquireLeaseDecision decision$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (SplitBrainResolver$AcquireLease$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$acquireLease();
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof SplitBrainResolver.AcquireLeaseResult) {
                    SplitBrainResolver.AcquireLeaseResult acquireLeaseResult = (SplitBrainResolver.AcquireLeaseResult)A1;
                    boolean holdingLease = acquireLeaseResult.holdingLease();
                    if (holdingLease) {
                        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition;
                        this.$outer.log().info(ClusterLogMarker$.MODULE$.sbrLeaseAcquired(this.decision$1), "SBR acquired lease for decision [{}]", (Object)this.decision$1);
                        Set<UniqueAddress> downedNodes = this.$outer.actOnDecision(this.decision$1);
                        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition2 = this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
                        if (releaseLeaseCondition2 instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved) {
                            SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved whenMembersRemoved = (SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved)releaseLeaseCondition2;
                            Set<UniqueAddress> nodes2 = whenMembersRemoved.nodes();
                            releaseLeaseCondition = new SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved((Set<UniqueAddress>)((Set)nodes2.union(downedNodes)));
                        } else {
                            releaseLeaseCondition = downedNodes.isEmpty() ? new SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed(Deadline$.MODULE$.now().$plus(this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter())) : new SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved(downedNodes);
                        }
                        this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition_$eq(releaseLeaseCondition);
                    } else {
                        DowningStrategy.Decision reverseDecision = this.$outer.strategy().reverseDecision(this.decision$1);
                        this.$outer.log().info(ClusterLogMarker$.MODULE$.sbrLeaseDenied(reverseDecision), "SBR couldn't acquire lease, reverse decision [{}] to [{}]", (Object)this.decision$1, (Object)reverseDecision);
                        this.$outer.actOnDecision(reverseDecision);
                        this.$outer.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition_$eq(SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$);
                    }
                    this.$outer.unstashAll();
                    this.$outer.context().become(this.$outer.receive());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof SplitBrainResolver.ReleaseLeaseResult) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if (SplitBrainResolver$Tick$.MODULE$.equals(A1)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.stash();
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = SplitBrainResolver$AcquireLease$.MODULE$.equals(object) ? true : (object instanceof SplitBrainResolver.AcquireLeaseResult ? true : (object instanceof SplitBrainResolver.ReleaseLeaseResult ? true : (SplitBrainResolver$Tick$.MODULE$.equals(object) ? true : true)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.decision$1 = decision$1;
            }
        };
    }

    public void akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseResult(boolean released) {
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
        if (releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed) {
            BoxedUnit boxedUnit;
            SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed whenTimeElapsed = (SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed)releaseLeaseCondition;
            Deadline deadline = whenTimeElapsed.deadline();
            if (released && deadline.isOverdue()) {
                this.log().info(ClusterLogMarker$.MODULE$.sbrLeaseReleased(), "SBR released lease.");
                this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition_$eq(SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Set<UniqueAddress> actOnDecision(DowningStrategy.Decision decision) {
        void var2_3;
        block3: {
            Set<UniqueAddress> set;
            try {
                set = this.strategy().nodesToDown(decision);
            }
            catch (IllegalStateException e) {
                this.log().warning(e.getMessage());
                set = this.strategy().nodesToDown(DowningStrategy$DownAll$.MODULE$);
            }
            Set<UniqueAddress> nodesToDown = set;
            this.observeDecision(decision, nodesToDown, this.unreachableDataCenters());
            if (!nodesToDown.nonEmpty()) break block3;
            boolean downMyself = nodesToDown.contains((Object)this.selfUniqueAddress());
            nodesToDown.foreach((Function1 & Serializable)uniqueAddress -> {
                SplitBrainResolverBase.$anonfun$actOnDecision$1(this, decision, uniqueAddress);
                return BoxedUnit.UNIT;
            });
            if (downMyself) {
                this.down(this.selfUniqueAddress(), decision);
            }
            this.resetReachabilityChangedStats();
            this.resetStableDeadline();
        }
        return var2_3;
    }

    @InternalStableApi
    public void observeDecision(DowningStrategy.Decision decision, Set<UniqueAddress> nodesToDown, Set<String> unreachableDataCenters) {
        boolean downMyself = nodesToDown.contains((Object)this.selfUniqueAddress());
        String indirectlyConnectedLogMessage = decision.isIndirectlyConnected() ? new StringBuilder(25).append(", indirectly connected [").append(this.strategy().indirectlyConnected().mkString(", ")).append("]").toString() : "";
        String unreachableDataCentersLogMessage = unreachableDataCenters.nonEmpty() ? new StringBuilder(20).append(", unreachable DCs [").append(unreachableDataCenters.mkString(", ")).append("]").toString() : "";
        this.log().warning(ClusterLogMarker$.MODULE$.sbrDowning(decision), new StringBuilder(0).append(new StringBuilder(38).append("SBR took decision ").append(decision).append(" and is downing [").append(((IterableOnceOps)nodesToDown.map((Function1 & Serializable)x$3 -> x$3.address())).mkString(", ")).append("]").append((Object)(downMyself ? " including myself," : "")).append(", ").toString()).append(new StringBuilder(28).append("[").append(this.strategy().unreachable().size()).append("] unreachable of [").append(this.strategy().members().size()).append("] members").toString()).append(indirectlyConnectedLogMessage).append(new StringBuilder(52).append(", all members in DC [").append(this.strategy().allMembersInDC().mkString(", ")).append("], full reachability status: [").append(this.strategy().reachability()).append("]").toString()).append(unreachableDataCentersLogMessage).toString());
    }

    public boolean isResponsible() {
        return this.leader() && this.selfMemberAdded();
    }

    public void unreachableMember(Member m) {
        block1: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2))) break block1;
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log().debug("SBR unreachableMember [{}]", (Object)m);
                this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    block0: {
                        this.strategy().addUnreachable(m);
                        this.updateReachabilityChangedStats();
                        this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                        if (this.reachabilityChangedStats().isEmpty()) break block0;
                        this.log().debug("SBR noticed {}", (Object)this.reachabilityChangedStats());
                    }
                });
            }
        }
    }

    public void reachableMember(Member m) {
        block1: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2))) break block1;
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log().debug("SBR reachableMember [{}]", (Object)m);
                this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    block0: {
                        this.strategy().addReachable(m);
                        this.updateReachabilityChangedStats();
                        this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                        if (this.reachabilityChangedStats().isEmpty()) break block0;
                        this.log().debug("SBR noticed {}", (Object)this.reachabilityChangedStats());
                    }
                });
            }
        }
    }

    public void reachabilityChanged(Reachability r) {
        this.strategy().setReachability(r);
    }

    private void updateReachabilityChangedStats() {
        long now = System.nanoTime();
        if (this.reachabilityChangedStats().changeCount() == 0L) {
            this.reachabilityChangedStats_$eq(new SplitBrainResolver.ReachabilityChangedStats(now, now, 1L));
        } else {
            SplitBrainResolver.ReachabilityChangedStats qual$1 = this.reachabilityChangedStats();
            long x$1 = now;
            long x$2 = this.reachabilityChangedStats().changeCount() + 1L;
            long x$3 = qual$1.copy$default$1();
            this.reachabilityChangedStats_$eq(qual$1.copy(x$3, x$1, x$2));
        }
    }

    public void unreachableDataCenter(String dc) {
        this.unreachableDataCenters_$eq((Set<String>)((Set)this.unreachableDataCenters().$plus((Object)dc)));
        this.log().warning("Data center [{}] observed as unreachable. Note that nodes in other data center will not be downed by SBR in this data center [{}]", (Object)dc, (Object)this.selfDc());
    }

    public void reachableDataCenter(String dc) {
        this.unreachableDataCenters_$eq((Set<String>)((Set)this.unreachableDataCenters().$minus((Object)dc)));
        this.log().info("Data center [{}] observed as reachable again", (Object)dc);
    }

    public void seenChanged(Set<Address> seenBy) {
        this.strategy().setSeenBy(seenBy);
    }

    public void addUp(Member m) {
        block4: {
            String string = this.selfDc();
            String string2 = m.dataCenter();
            if (string != null ? !string.equals(string2) : string2 != null) break block4;
            this.log().debug("SBR add Up [{}]", (Object)m);
            this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                block0: {
                    this.strategy().add(m);
                    UniqueAddress uniqueAddress = m.uniqueAddress();
                    UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
                    if (uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null) break block0;
                    this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.selfMemberAdded_$eq(true));
                }
            });
            DowningStrategy downingStrategy = this.strategy();
            if (downingStrategy instanceof StaticQuorum) {
                BoxedUnit boxedUnit;
                StaticQuorum staticQuorum = (StaticQuorum)downingStrategy;
                if (staticQuorum.isTooManyMembers()) {
                    this.log().warning("The cluster size is [{}] and static-quorum.quorum-size is [{}]. You should not add more than [{}] (static-quorum.size * 2 - 1) members to the cluster. If the exceeded cluster size remains when a SBR decision is needed it will down all nodes.", (Object)BoxesRunTime.boxToInteger((int)staticQuorum.membersWithRole().size()), (Object)BoxesRunTime.boxToInteger((int)staticQuorum.quorumSize()), (Object)BoxesRunTime.boxToInteger((int)(staticQuorum.quorumSize() * 2 - 1)));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void leaving(Member m) {
        block0: {
            String string = this.selfDc();
            String string2 = m.dataCenter();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.log().debug("SBR leaving [{}]", (Object)m);
            this.mutateMemberInfo(false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.strategy().add(m));
        }
    }

    public void exited(Member m) {
        block0: {
            String string = this.selfDc();
            String string2 = m.dataCenter();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.log().debug("SBR exited [{}]", (Object)m);
            this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.strategy().add(m));
        }
    }

    public void addJoining(Member m) {
        block0: {
            String string = this.selfDc();
            String string2 = m.dataCenter();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.log().debug("SBR add Joining/WeaklyUp [{}]", (Object)m);
            this.strategy().add(m);
        }
    }

    public void addWeaklyUp(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.selfMemberAdded_$eq(true));
        }
        this.addJoining(m);
    }

    public void remove(Member m) {
        block2: {
            String string = this.selfDc();
            String string2 = m.dataCenter();
            if (string != null ? !string.equals(string2) : string2 != null) break block2;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
            } else {
                this.mutateMemberInfo(false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved whenMembersRemoved;
                    Set<UniqueAddress> downedNodes;
                    Set remainingDownedNodes;
                    this.log().debug("SBR remove [{}]", (Object)m);
                    this.strategy().remove(m);
                    this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                    SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
                    SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition2 = releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved ? ((remainingDownedNodes = (Set)(downedNodes = (whenMembersRemoved = (SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved)releaseLeaseCondition).nodes()).$minus((Object)m.uniqueAddress())).isEmpty() ? new SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed(Deadline$.MODULE$.now().$plus(this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter())) : new SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved((Set<UniqueAddress>)remainingDownedNodes)) : releaseLeaseCondition;
                    this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition_$eq(releaseLeaseCondition2);
                });
            }
        }
    }

    private void releaseLease() {
        ExecutionContext ec = this.internalDispatcher();
        this.strategy().lease().foreach((Function1 & Serializable)l -> {
            BoxedUnit boxedUnit;
            SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition();
            SplitBrainResolver$ReleaseLeaseCondition$NoLease$ splitBrainResolver$ReleaseLeaseCondition$NoLease$ = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
            if (releaseLeaseCondition == null ? splitBrainResolver$ReleaseLeaseCondition$NoLease$ != null : !releaseLeaseCondition.equals(splitBrainResolver$ReleaseLeaseCondition$NoLease$)) {
                this.log().debug("SBR releasing lease");
                boxedUnit = akka.pattern.package$.MODULE$.pipe(l.release().recover((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                        return (B1)bl;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                }, ec).map((Function1 & Serializable)released -> SplitBrainResolverBase.$anonfun$releaseLease$2(BoxesRunTime.unboxToBoolean((Object)released)), ec), ec).pipeTo(this.self(), this.self());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private final String earliestTimeOfDecision$1() {
        return Instant.now().plus(this.stableAfter.toMillis(), ChronoUnit.MILLIS).toString();
    }

    public static final /* synthetic */ boolean $anonfun$thisActorSystemWasQuarantined$1(UniqueAddress remote$1, Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = remote$1;
        return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
    }

    public static final /* synthetic */ SplitBrainResolver.AcquireLeaseResult $anonfun$acquireLease$2(boolean holdingLease) {
        return new SplitBrainResolver.AcquireLeaseResult(holdingLease);
    }

    public static final /* synthetic */ void $anonfun$actOnDecision$1(SplitBrainResolverBase $this, DowningStrategy.Decision decision$2, UniqueAddress uniqueAddress) {
        block0: {
            UniqueAddress uniqueAddress2 = uniqueAddress;
            UniqueAddress uniqueAddress3 = $this.selfUniqueAddress();
            if (!(uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3))) break block0;
            $this.down(uniqueAddress, decision$2);
        }
    }

    public static final /* synthetic */ SplitBrainResolver.ReleaseLeaseResult $anonfun$releaseLease$2(boolean released) {
        return new SplitBrainResolver.ReleaseLeaseResult(released);
    }

    public SplitBrainResolverBase(FiniteDuration stableAfter, DowningStrategy _strategy) {
        this.stableAfter = stableAfter;
        this._strategy = _strategy;
        Actor.$init$((Actor)this);
        StashSupport.$init$((StashSupport)this);
        UnrestrictedStash.$init$((UnrestrictedStash)this);
        Timers.$init$((Timers)this);
        this.log = Logging$.MODULE$.withMarker((Actor)this);
        this.settings = new SplitBrainResolverSettings(this.context().system().settings().config());
        this.timers().startTimerWithFixedDelay((Object)SplitBrainResolver$Tick$.MODULE$, (Object)SplitBrainResolver$Tick$.MODULE$, this.tickInterval());
        this.leader = false;
        this.selfMemberAdded = false;
        this.resetStableDeadline();
        this.reachabilityChangedStats = new SplitBrainResolver.ReachabilityChangedStats(System.nanoTime(), System.nanoTime(), 0L);
        this.akka$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
        this.unreachableDataCenters = Predef$.MODULE$.Set().empty();
        Statics.releaseFence();
    }
}

