/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.NoSuchPrincipalException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImpersonationImpl
implements Impersonation,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger((Class)ImpersonationImpl.class);
    private final UserImpl user;
    private final UserManagerImpl userManager;

    ImpersonationImpl(UserImpl user, UserManagerImpl userManager) throws RepositoryException {
        this.user = user;
        this.userManager = userManager;
    }

    public PrincipalIterator getImpersonators() throws RepositoryException {
        Set impersonators = this.getImpersonatorNames();
        if (impersonators.isEmpty()) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        PrincipalManager pMgr = this.user.getSession().getPrincipalManager();
        HashSet<Principal> s = new HashSet<Principal>();
        Iterator it = impersonators.iterator();
        while (it.hasNext()) {
            String pName = it.next().toString();
            Principal p = null;
            if (pMgr.hasPrincipal(pName)) {
                try {
                    p = pMgr.getPrincipal(pName);
                }
                catch (NoSuchPrincipalException e) {
                    // empty catch block
                }
            }
            if (p == null) {
                log.debug("Impersonator " + pName + " does not correspond to a known Principal.");
                p = new PrincipalImpl(pName);
            }
            s.add(p);
        }
        return new PrincipalIteratorAdapter(s);
    }

    public synchronized boolean grantImpersonation(Principal principal) throws RepositoryException {
        if (principal instanceof AdminPrincipal || principal instanceof SystemPrincipal) {
            log.debug("Admin and System principal are already granted impersonation.");
            return false;
        }
        Authorizable auth = this.user.userManager.getAuthorizable(principal);
        if (auth == null || auth.isGroup()) {
            log.debug("Cannot grant impersonation to a principal that is a Group or an unknown Authorizable.");
            return false;
        }
        String pName = principal.getName();
        PrincipalIterator it = this.user.getPrincipals();
        while (it.hasNext()) {
            Principal p = it.nextPrincipal();
            if (!p.getName().equals(pName)) continue;
            log.debug("Cannot grant impersonation to oneself.");
            return false;
        }
        boolean granted = false;
        Set impersonators = this.getImpersonatorNames();
        if (impersonators.add(pName)) {
            this.updateImpersonatorNames(impersonators);
            granted = true;
        }
        return granted;
    }

    public synchronized boolean revokeImpersonation(Principal principal) throws RepositoryException {
        if (principal instanceof AdminPrincipal || principal instanceof SystemPrincipal) {
            log.debug("Admin and System principal are always granted impersonation.");
            return false;
        }
        boolean revoked = false;
        String pName = principal.getName();
        Set impersonators = this.getImpersonatorNames();
        if (impersonators.remove(pName)) {
            this.updateImpersonatorNames(impersonators);
            revoked = true;
        }
        return revoked;
    }

    public boolean allows(Subject subject) throws RepositoryException {
        if (subject == null) {
            return false;
        }
        if (!subject.getPrincipals(AdminPrincipal.class).isEmpty() || !subject.getPrincipals(SystemPrincipal.class).isEmpty()) {
            return true;
        }
        HashSet<String> principalNames = new HashSet<String>();
        Iterator<Principal> it = subject.getPrincipals().iterator();
        while (it.hasNext()) {
            principalNames.add(it.next().getName());
        }
        boolean allows = false;
        try {
            Set impersonators = this.getImpersonatorNames();
            allows = impersonators.removeAll(principalNames);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return allows;
    }

    private Set getImpersonatorNames() throws RepositoryException {
        HashSet<String> princNames = new HashSet<String>();
        if (this.user.getNode().hasProperty(P_IMPERSONATORS)) {
            Value[] vs = this.user.getNode().getProperty(P_IMPERSONATORS).getValues();
            for (int i = 0; i < vs.length; ++i) {
                princNames.add(vs[i].getString());
            }
        }
        return princNames;
    }

    private void updateImpersonatorNames(Set principalNames) throws RepositoryException {
        NodeImpl userNode = this.user.getNode();
        try {
            String[] pNames = principalNames.toArray(new String[principalNames.size()]);
            if (pNames.length == 0) {
                PropertyImpl prop = userNode.getProperty(P_IMPERSONATORS);
                this.userManager.removeProtectedItem(prop, userNode);
            } else {
                Value[] values = new Value[pNames.length];
                for (int i = 0; i < pNames.length; ++i) {
                    values[i] = new StringValue(pNames[i]);
                }
                this.userManager.setProtectedProperty(userNode, P_IMPERSONATORS, values);
            }
        }
        catch (RepositoryException e) {
            userNode.refresh(false);
            throw e;
        }
    }
}

