/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.alts.AltsChannelCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelBuilder
extends ForwardingChannelBuilder<AltsChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private final AltsChannelCredentials.Builder credentialsBuilder = new AltsChannelCredentials.Builder();

    public static final AltsChannelBuilder forTarget(String target) {
        return new AltsChannelBuilder(target);
    }

    public static AltsChannelBuilder forAddress(String name, int port) {
        return AltsChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    private AltsChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target);
    }

    public AltsChannelBuilder addTargetServiceAccount(String targetServiceAccount) {
        this.credentialsBuilder.addTargetServiceAccount(targetServiceAccount);
        return this;
    }

    public AltsChannelBuilder enableUntrustedAltsForTesting() {
        this.credentialsBuilder.enableUntrustedAltsForTesting();
        return this;
    }

    public AltsChannelBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.credentialsBuilder.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalProtocolNegotiator.ClientFactory)this.credentialsBuilder.buildProtocolNegotiatorFactory());
        return this.delegate().build();
    }

    @Nullable
    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.credentialsBuilder.buildProtocolNegotiatorFactory().newNegotiator();
    }
}

