/*
 * Decompiled with CFR 0.152.
 */
package javax.json.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;

public abstract class JsonProvider {
    private static final String DEFAULT_PROVIDER = "org.apache.johnzon.core.JsonProviderImpl";

    protected JsonProvider() {
    }

    public static JsonProvider provider() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){

                @Override
                public JsonProvider run() {
                    return JsonProvider.doLoadProvider();
                }
            });
        }
        return JsonProvider.doLoadProvider();
    }

    private static JsonProvider doLoadProvider() throws JsonException {
        String className;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl == null) {
            tccl = ClassLoader.getSystemClassLoader();
        }
        if ((className = System.getProperty(JsonProvider.class.getName())) != null) {
            try {
                return (JsonProvider)JsonProvider.class.cast(tccl.loadClass(className.trim()).newInstance());
            }
            catch (Exception e) {
                throw new JsonException("Specified provider as system property can't be loaded: " + className, e);
            }
        }
        Iterator<JsonProvider> providers = ServiceLoader.load(JsonProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        try {
            return (JsonProvider)JsonProvider.class.cast(tccl.loadClass(DEFAULT_PROVIDER).newInstance());
        }
        catch (Throwable cnfe) {
            throw new JsonException("org.apache.johnzon.core.JsonProviderImpl not found", cnfe);
        }
    }

    public abstract JsonParser createParser(Reader var1);

    public abstract JsonParser createParser(InputStream var1);

    public abstract JsonParserFactory createParserFactory(Map<String, ?> var1);

    public abstract JsonGenerator createGenerator(Writer var1);

    public abstract JsonGenerator createGenerator(OutputStream var1);

    public abstract JsonGeneratorFactory createGeneratorFactory(Map<String, ?> var1);

    public abstract JsonReader createReader(Reader var1);

    public abstract JsonReader createReader(InputStream var1);

    public abstract JsonWriter createWriter(Writer var1);

    public abstract JsonWriter createWriter(OutputStream var1);

    public abstract JsonWriterFactory createWriterFactory(Map<String, ?> var1);

    public abstract JsonReaderFactory createReaderFactory(Map<String, ?> var1);

    public abstract JsonObjectBuilder createObjectBuilder();

    public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
        throw new UnsupportedOperationException();
    }

    public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public abstract JsonArrayBuilder createArrayBuilder();

    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonPointer createPointer(String path) {
        throw new UnsupportedOperationException();
    }

    public abstract JsonBuilderFactory createBuilderFactory(Map<String, ?> var1);

    public JsonString createValue(String value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(int value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(long value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(double value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    public JsonNumber createValue(BigInteger value) {
        throw new UnsupportedOperationException();
    }

    public JsonPatch createPatch(JsonArray array) {
        throw new UnsupportedOperationException();
    }

    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        throw new UnsupportedOperationException();
    }

    public JsonPatchBuilder createPatchBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
        throw new UnsupportedOperationException();
    }

    public JsonMergePatch createMergePatch(JsonValue patch) {
        throw new UnsupportedOperationException();
    }

    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        throw new UnsupportedOperationException();
    }
}

