/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import com.github.difflib.patch.VerifyChunk;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public abstract class AbstractDelta<T>
implements Serializable {
    private final Chunk<T> source;
    private final Chunk<T> target;
    private final DeltaType type;

    public AbstractDelta(DeltaType type, Chunk<T> source, Chunk<T> target) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        Objects.requireNonNull(type);
        this.type = type;
        this.source = source;
        this.target = target;
    }

    public Chunk<T> getSource() {
        return this.source;
    }

    public Chunk<T> getTarget() {
        return this.target;
    }

    public DeltaType getType() {
        return this.type;
    }

    protected VerifyChunk verifyChunkToFitTarget(List<T> target) throws PatchFailedException {
        return this.getSource().verifyChunk(target);
    }

    protected VerifyChunk verifyAntApplyTo(List<T> target) throws PatchFailedException {
        VerifyChunk verify = this.verifyChunkToFitTarget(target);
        if (verify == VerifyChunk.OK) {
            this.applyTo(target);
        }
        return verify;
    }

    protected abstract void applyTo(List<T> var1) throws PatchFailedException;

    protected abstract void restore(List<T> var1);

    public abstract AbstractDelta<T> withChunks(Chunk<T> var1, Chunk<T> var2);

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.target, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDelta other = (AbstractDelta)obj;
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (!Objects.equals(this.target, other.target)) {
            return false;
        }
        return this.type == other.type;
    }
}

