/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.pro.packaged.bD;
import liquibase.pro.packaged.bb;

public final class bS {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 1000;
    static final int MAX_SEGMENT_LEN = 262144;
    private final bD _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public bS(bD bD2) {
        this._allocator = bD2;
    }

    public final void releaseBuffers() {
        if (this._allocator == null) {
            this.resetWithEmpty();
            return;
        }
        if (this._currentSegment != null) {
            this.resetWithEmpty();
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(2, cArray);
        }
    }

    public final void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWith(char c2) {
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(1);
        }
        this._currentSegment[0] = c2;
        bS bS2 = this;
        bS2._segmentSize = 1;
        bS2._currentSize = 1;
    }

    public final void resetWithShared(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithCopy(char[] cArray, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        bS bS2 = this;
        bS2._segmentSize = 0;
        bS2._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public final void resetWithCopy(String string, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        bS bS2 = this;
        bS2._segmentSize = 0;
        bS2._currentSize = 0;
        this.append(string, n2, n3);
    }

    public final void resetWithString(String string) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    public final char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    private char[] buf(int n2) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(2, n2);
        }
        return new char[Math.max(n2, 1000)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        bS bS2 = this;
        bS2._segmentSize = 0;
        bS2._currentSize = 0;
    }

    public final int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public final int getTextOffset() {
        if (this._inputStart >= 0) {
            return this._inputStart;
        }
        return 0;
    }

    public final boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public final char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            if (this._currentSegment == null) {
                return NO_CHARS;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public final String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen <= 0) {
                    this._resultString = "";
                    return "";
                }
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n2 = this._segmentSize;
                int n3 = this._currentSize;
                if (n2 == 0) {
                    this._resultString = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n2 + n3);
                    if (this._segments != null) {
                        int n4 = this._segments.size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            char[] cArray = this._segments.get(n3);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public final char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (this._resultArray == null) {
            this._resultArray = cArray = this.resultArray();
        }
        return cArray;
    }

    public final BigDecimal contentsAsDecimal() {
        if (this._resultArray != null) {
            return bb.parseBigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            return bb.parseBigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0 && this._currentSegment != null) {
            return bb.parseBigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return bb.parseBigDecimal(this.contentsAsArray());
    }

    public final double contentsAsDouble() {
        return bb.parseDouble(this.contentsAsString());
    }

    public final int contentsAsInt(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -bb.parseInt(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return bb.parseInt(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -bb.parseInt(this._currentSegment, 1, this._currentSize - 1);
        }
        return bb.parseInt(this._currentSegment, 0, this._currentSize);
    }

    public final long contentsAsLong(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -bb.parseLong(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return bb.parseLong(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -bb.parseLong(this._currentSegment, 1, this._currentSize - 1);
        }
        return bb.parseLong(this._currentSegment, 0, this._currentSize);
    }

    public final int contentsToWriter(Writer writer) {
        int n2;
        if (this._resultArray != null) {
            writer.write(this._resultArray);
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            writer.write(this._resultString);
            return this._resultString.length();
        }
        if (this._inputStart >= 0) {
            int n3 = this._inputLen;
            if (n3 > 0) {
                writer.write(this._inputBuffer, this._inputStart, n3);
            }
            return n3;
        }
        int n4 = 0;
        if (this._segments != null) {
            int n5 = this._segments.size();
            for (n2 = 0; n2 < n5; ++n2) {
                char[] cArray = this._segments.get(n2);
                int n6 = cArray.length;
                writer.write(cArray, 0, n6);
                n4 += n6;
            }
        }
        if ((n2 = this._currentSize) > 0) {
            writer.write(this._currentSegment, 0, n2);
            n4 += n2;
        }
        return n4;
    }

    public final void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public final void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
            cArray = this._currentSegment;
        }
        cArray[this._currentSize++] = c2;
    }

    public final void append(char[] cArray, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n4);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final void append(String string, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            int n6 = n2;
            string.getChars(n6, n6 + n3, cArray, this._currentSize);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            int n7 = n2;
            string.getChars(n7, n7 + n5, cArray, this._currentSize);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n4, this._currentSegment, 0);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (this._currentSegment == null) {
                this._currentSegment = this.buf(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public final char[] emptyAndGetCurrentSegment() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        char[] cArray = this._currentSegment;
        if (this._currentSegment == null) {
            this._currentSegment = cArray = this.buf(0);
        }
        return cArray;
    }

    public final int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public final void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public final String setCurrentAndReturn(int n2) {
        String string;
        this._currentSize = n2;
        if (this._segmentSize > 0) {
            return this.contentsAsString();
        }
        n2 = this._currentSize;
        this._resultString = string = n2 == 0 ? "" : new String(this._currentSegment, 0, n2);
        return string;
    }

    public final char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize += n2;
        this._currentSize = 0;
        int n3 = n2;
        n2 = n3 + (n3 >> 1);
        if (n2 < 1000) {
            n2 = 1000;
        } else if (n2 > 262144) {
            n2 = 262144;
        }
        char[] cArray = this.carr(n2);
        this._currentSegment = cArray;
        return cArray;
    }

    public final char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n2 = this._currentSegment.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 > 262144) {
            int n4 = n2;
            n3 = n4 + (n4 >> 2);
        }
        this._currentSegment = Arrays.copyOf(cArray, n3);
        return this._currentSegment;
    }

    public final char[] expandCurrentSegment(int n2) {
        char[] cArray = this._currentSegment;
        if (this._currentSegment.length >= n2) {
            return cArray;
        }
        this._currentSegment = cArray = Arrays.copyOf(cArray, n2);
        return cArray;
    }

    public final String toString() {
        return this.contentsAsString();
    }

    private void unshare(int n2) {
        int n3 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n4 = this._inputStart;
        this._inputStart = -1;
        n2 = n3 + n2;
        if (this._currentSegment == null || n2 > this._currentSegment.length) {
            this._currentSegment = this.buf(n2);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        this._segmentSize = 0;
        this._currentSize = n3;
    }

    private void expand(int n2) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        this._currentSize = 0;
        int n3 = cArray.length;
        int n4 = n3 + (n3 >> 1);
        if (n4 < 1000) {
            n4 = 1000;
        } else if (n4 > 262144) {
            n4 = 262144;
        }
        this._currentSegment = this.carr(n4);
    }

    private char[] resultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            int n2 = this._inputLen;
            if (n2 <= 0) {
                return NO_CHARS;
            }
            int n3 = this._inputStart;
            if (n3 == 0) {
                return Arrays.copyOf(this._inputBuffer, n2);
            }
            int n4 = n3;
            return Arrays.copyOfRange(this._inputBuffer, n4, n4 + n2);
        }
        int n5 = this.size();
        if (n5 <= 0) {
            return NO_CHARS;
        }
        int n6 = 0;
        char[] cArray = this.carr(n5);
        if (this._segments != null) {
            int n7 = this._segments.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n8 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n6, n8);
                n6 += n8;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n6, this._currentSize);
        return cArray;
    }

    private char[] carr(int n2) {
        return new char[n2];
    }
}

