/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.provision.steps;

import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.Scope;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedInfrastructureAsCode;
import com.xebialabs.deployit.provision.ProvisionHelper$;
import com.xebialabs.deployit.provision.steps.BaseStep;
import com.xebialabs.deployit.provision.steps.ScopeValidator;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@StepMetadata(name="create-dictionary")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\n\u0015\u0001}AQ!\u000f\u0001\u0005\u0002iB\u0011\u0002\u0010\u0001A\u0002\u0003\u0007I\u0011B\u001f\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0013a\u0005\"C*\u0001\u0001\u0004\u0005\t\u0015)\u0003?\u0011%!\u0006\u00011AA\u0002\u0013%Q\u000bC\u0005f\u0001\u0001\u0007\t\u0019!C\u0005M\"I\u0001\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0016\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0011\u001dq\u0007\u00011A\u0005\n=Da!\u001d\u0001!B\u0013Y\u0007\"\u0002:\u0001\t\u0003\u001a\b\"B<\u0001\t\u0003A\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011CA\n\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\r\u0001\t\u0013\t\u0019\u0004\u0003\u0004\u0002L\u0001!I!\u0010\u0005\b\u0003\u001b\u0002A\u0011BA(\u0005Q\u0019%/Z1uK\u0012K7\r^5p]\u0006\u0014\u0018p\u0015;fa*\u0011QCF\u0001\u0006gR,\u0007o\u001d\u0006\u0003/a\t\u0011\u0002\u001d:pm&\u001c\u0018n\u001c8\u000b\u0005eQ\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011#\u0002\u0001!Q12\u0004CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%RS\"\u0001\u000b\n\u0005-\"\"\u0001\u0003\"bg\u0016\u001cF/\u001a9\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00024m_^T!!\r\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u000241\u00051\u0001\u000f\\;hS:L!!\u000e\u0018\u0003\u0017A\u0013XM^5foN#X\r\u001d\t\u0003S]J!\u0001\u000f\u000b\u0003\u001dM\u001bw\u000e]3WC2LG-\u0019;pe\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003S\u0001\tQ\"\u001a8wSJ|g.\\3oi&#W#\u0001 \u0011\u0005}BeB\u0001!G!\t\tE)D\u0001C\u0015\t\u0019e$\u0001\u0004=e>|GO\u0010\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\tR\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H\t\u0006\tRM\u001c<je>tW.\u001a8u\u0013\u0012|F%Z9\u0015\u00055\u000b\u0006C\u0001(P\u001b\u0005!\u0015B\u0001)E\u0005\u0011)f.\u001b;\t\u000fI\u001b\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\u0015tg/\u001b:p]6,g\u000e^%eA\u0005AA-\u001a9m_f,G-F\u0001W!\t9&M\u0004\u0002YA:\u0011\u0011l\u0018\b\u00035zs!aW/\u000f\u0005\u0005c\u0016\"A\u000f\n\u0005ma\u0012BA\r\u001b\u0013\t9\u0002$\u0003\u0002b-\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\u0011\u0012\u0015m]3EKBdw._3e\u0013:4'/Y:ueV\u001cG/\u001e:f\u0003N\u001cu\u000eZ3UsB,'BA1\u0017\u00031!W\r\u001d7ps\u0016$w\fJ3r)\tiu\rC\u0004S\r\u0005\u0005\t\u0019\u0001,\u0002\u0013\u0011,\u0007\u000f\\8zK\u0012\u0004\u0013\u0001G1eI\u0016sg/\u001b:p]6,g\u000e\u001e+p\u0005>,h\u000eZ\"JgV\t1\u000e\u0005\u0002OY&\u0011Q\u000e\u0012\u0002\b\u0005>|G.Z1o\u0003q\tG\rZ#om&\u0014xN\\7f]R$vNQ8v]\u0012\u001c\u0015j]0%KF$\"!\u00149\t\u000fIK\u0011\u0011!a\u0001W\u0006I\u0012\r\u001a3F]ZL'o\u001c8nK:$Hk\u001c\"pk:$7)S:!\u0003)9W\r\u001e)sKZLWm\u001e\u000b\u0002iB\u0011Q&^\u0005\u0003m:\u0012q\u0001\u0015:fm&,w/\u0001\rwC2LG-\u0019;f\u0003:$7+\u001a;QCJ\fW.\u001a;feN$\"!T=\t\u000bid\u0001\u0019A>\u0002\u0007\r$\b\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fa\u0005)!/\u001e7fg&\u0019\u0011\u0011A?\u00031M#X\r\u001d)pgR\u001cuN\\:ueV\u001cGoQ8oi\u0016DH\u000fK\u0002\r\u0003\u000b\u00012\u0001`A\u0004\u0013\r\tI! \u0002\u0012%VdW\rU8ti\u000e{gn\u001d;sk\u000e$\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u00075\u000by\u0001C\u0003{\u001b\u0001\u000710\u0001\u0006sKB|7/\u001b;pef,\"!!\u0006\u0011\t\u0005]\u00111D\u0007\u0003\u00033Q1!!\u0005\u0019\u0013\u0011\ti\"!\u0007\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-A\u0004fq\u0016\u001cW\u000f^3\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004[\u0005\u0015\u0012bAA\u0014]\ta1\u000b^3q\u000bbLGoQ8eK\"1!p\u0004a\u0001\u0003W\u00012!LA\u0017\u0013\r\tyC\f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fQbZ3u\t&\u001cG/[8oCJLH\u0003BA\u001b\u0003\u000f\"B!a\u000e\u0002DA!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>A\n1!\u001e3n\u0013\u0011\t\t%a\u000f\u0003\u0015\u0011K7\r^5p]\u0006\u0014\u0018\u0010C\u0004\u0002FA\u0001\u001d!a\u000b\u0002\u000f\r|g\u000e^3yi\"1\u0011\u0011\n\tA\u0002y\nA\u0002Z5di&|g.\u0019:z\u0013\u0012\fqbZ3u\t&\u001cG/[8oCJL\u0018\nZ\u0001\u000fO\u0016$XI\u001c<je>tW.\u001a8u)\u0011\t\t&a\u0016\u0011\t\u0005e\u00121K\u0005\u0005\u0003+\nYDA\u0006F]ZL'o\u001c8nK:$\bbBA#%\u0001\u000f\u00111\u0006\u0015\b\u0001\u0005m\u0013\u0011MA2!\ra\u0018QL\u0005\u0004\u0003?j(\u0001D*uKBlU\r^1eCR\f\u0017\u0001\u00028b[\u0016\f#!!\u001a\u0002#\r\u0014X-\u0019;f[\u0011L7\r^5p]\u0006\u0014\u0018\u0010")
public class CreateDictionaryStep
implements BaseStep,
PreviewStep,
ScopeValidator {
    private String environmentId;
    private BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> deployed;
    private boolean addEnvironmentToBoundCIs;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans", calculated=false)
    private String description;
    @StepParameter(description="Execution order of the step", calculated=false)
    private Integer order;

    @Override
    public void validateScope(Scope scope, Scope requiredScope) {
        ScopeValidator.validateScope$(this, scope, requiredScope);
    }

    @Override
    public int getOrder() {
        return BaseStep.getOrder$(this);
    }

    @Override
    public String getDescription() {
        return BaseStep.getDescription$(this);
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public void description_$eq(String x$1) {
        this.description = x$1;
    }

    @Override
    public Integer order() {
        return this.order;
    }

    @Override
    public void order_$eq(Integer x$1) {
        this.order = x$1;
    }

    private String environmentId() {
        return this.environmentId;
    }

    private void environmentId_$eq(String x$1) {
        this.environmentId = x$1;
    }

    private BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> deployed() {
        return this.deployed;
    }

    private void deployed_$eq(BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> x$1) {
        this.deployed = x$1;
    }

    private boolean addEnvironmentToBoundCIs() {
        return this.addEnvironmentToBoundCIs;
    }

    private void addEnvironmentToBoundCIs_$eq(boolean x$1) {
        this.addEnvironmentToBoundCIs = x$1;
    }

    public Preview getPreview() {
        return Preview.withContents((String)new StringBuilder(20).append("Create dictionary '").append(this.getDictionaryId()).append("'").toString());
    }

    @RulePostConstruct
    public void validateAndSetParameters(StepPostConstructContext ctx) {
        this.validate(ctx);
        this.order_$eq(this.order() != null ? this.order() : Predef$.MODULE$.int2Integer(80));
        this.deployed_$eq((BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container>)((BaseDeployedInfrastructureAsCode)ctx.getDelta().getDeployed()));
        this.environmentId_$eq(ProvisionHelper$.MODULE$.getProvisionEnvironmentId(this.deployed().getEnvironmentPath(), ctx.getDeployedApplication().getEnvironment().getId()));
        String string = this.environmentId();
        String string2 = ctx.getDeployedApplication().getEnvironment().getId();
        this.addEnvironmentToBoundCIs_$eq(string == null ? string2 != null : !string.equals(string2));
        if (this.description() == null || this.description().isEmpty()) {
            this.description_$eq(new StringBuilder(34).append("Create dictionary for ").append(this.deployed().getName()).append(" from output").toString());
            return;
        }
    }

    private void validate(StepPostConstructContext ctx) {
        this.validateScope(ctx.getScope(), Scope.DEPLOYED);
        if (!(ctx.getDelta().getDeployed() instanceof BaseDeployedInfrastructureAsCode)) {
            throw new IllegalArgumentException(new StringBuilder(55).append("This step can only be applied to '").append(Type.valueOf(BaseDeployedInfrastructureAsCode.class).toString()).append("' Configuration Items").toString());
        }
        Operation operation = ctx.getDelta().getOperation();
        Operation operation2 = Operation.CREATE;
        if (operation == null ? operation2 != null : !operation.equals(operation2)) {
            Operation operation3 = ctx.getDelta().getOperation();
            Operation operation4 = Operation.MODIFY;
            if (operation3 == null ? operation4 != null : !operation3.equals(operation4)) {
                throw new IllegalArgumentException(new StringBuilder(52).append("This step can only be applied to '").append(Operation.CREATE).append("' or '").append(Operation.MODIFY).append("' operations").toString());
            }
        }
    }

    public RepositoryService repository() {
        return RepositoryServiceHolder.getRepositoryService();
    }

    public StepExitCode execute(ExecutionContext ctx) {
        ExecutionContext context = ctx;
        String dictionaryId = this.getDictionaryId();
        Dictionary dictionary = this.getDictionary(dictionaryId, context);
        dictionary.setEntries(this.deployed().getOutputVariables());
        this.repository().createOrUpdate((ConfigurationItem[])new Dictionary[]{dictionary});
        context.logOutput(new StringBuilder(22).append("Dictionary created: '").append(dictionaryId).append("'").toString());
        Environment environment = this.getEnvironment(context);
        if (!((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(environment.getDictionaries()).asScala().map((Function1 & Serializable)x$3 -> x$3.getId())).contains((Object)dictionaryId)) {
            environment.getDictionaries().add(dictionary);
            this.repository().update((ConfigurationItem[])new Environment[]{environment});
            context.logOutput(new StringBuilder(34).append("Dictionary added to Environment '").append(this.environmentId()).append("'").toString());
        }
        this.deployed().getBoundConfigurationItems().add(dictionary);
        Object object = this.addEnvironmentToBoundCIs() ? BoxesRunTime.boxToBoolean((boolean)this.deployed().getBoundConfigurationItems().add(environment)) : BoxedUnit.UNIT;
        return StepExitCode.SUCCESS;
    }

    private Dictionary getDictionary(String dictionaryId, ExecutionContext context) {
        if (this.repository().exists(dictionaryId)) {
            ConfigurationItem ci = this.repository().read(dictionaryId);
            if (!(ci instanceof Dictionary)) {
                throw new IllegalArgumentException(new StringBuilder(22).append("'").append(dictionaryId).append("' is not a dictionary").toString());
            }
            return (Dictionary)ci;
        }
        ProvisionHelper$.MODULE$.createDirectories(dictionaryId, context);
        Dictionary dict = new Dictionary();
        dict.setId(dictionaryId);
        return dict;
    }

    private String getDictionaryId() {
        Some some;
        String s;
        Option option = Option$.MODULE$.apply((Object)this.deployed().getDictionaryPath());
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s = (String)(some = (Some)option).value()))) {
            return ProvisionHelper$.MODULE$.generateId(this.deployed().getDictionaryPath(), this.environmentId());
        }
        return new StringBuilder(11).append(this.environmentId().substring(0, this.environmentId().lastIndexOf("/") + 1)).append(this.deployed().getName()).append("-dictionary").toString();
    }

    private Environment getEnvironment(ExecutionContext context) {
        return ProvisionHelper$.MODULE$.getOrCreateEnvironment(this.environmentId(), context);
    }

    public CreateDictionaryStep() {
        BaseStep.$init$(this);
        ScopeValidator.$init$(this);
        this.addEnvironmentToBoundCIs = false;
    }
}

