/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.AbstractCollectionFormInjector;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class MapFormInjector
extends AbstractCollectionFormInjector<Map> {
    private final StringParameterInjector keyInjector;

    public MapFormInjector(Class collectionType, Class keyType, Class valueType, String prefix, ResteasyProviderFactory factory) {
        super(collectionType, valueType, prefix, Pattern.compile("^" + prefix + "\\[([0-9a-zA-Z_\\-\\.~]+)\\]"), factory);
        this.keyInjector = new StringParameterInjector(keyType, keyType, null, Form.class, null, null, new Annotation[0], factory);
    }

    @Override
    protected Map createInstance(Class collectionType) {
        if (collectionType.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap();
        }
        if (collectionType.isAssignableFrom(TreeMap.class)) {
            return new TreeMap();
        }
        throw new RuntimeException(Messages.MESSAGES.unsupportedCollectionType(collectionType));
    }

    @Override
    protected void addTo(Map collection, String key, Object value) {
        collection.put(this.keyInjector.extractValue(key), value);
    }
}

