/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import liquibase.logging.Logger;
import liquibase.logging.core.AbstractLogService;
import liquibase.logging.core.BufferedLogger;
import liquibase.util.ISODateFormat;

public class BufferedLogService
extends AbstractLogService {
    public static final int MAX_LOG_LENGTH = 10000000;
    private List<BufferedLogMessage> log = new ArrayList<BufferedLogMessage>();

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public Logger getLog(Class clazz) {
        return new BufferedLogger(clazz, this);
    }

    public List<BufferedLogMessage> getLog() {
        return this.log;
    }

    public String getLogAsString(Level minimumLevel) {
        StringBuilder returnLog = new StringBuilder();
        for (BufferedLogMessage message : this.log) {
            if (minimumLevel != null && minimumLevel.intValue() > message.getLevel().intValue()) continue;
            returnLog.append("[").append(new ISODateFormat().format(message.getTimestamp())).append("] ");
            returnLog.append(message.getLevel().getName()).append(" ");
            returnLog.append(message.getMessage());
            returnLog.append("\n");
            if (message.getThrowable() == null) continue;
            try {
                StringWriter stringWriter = new StringWriter();
                Throwable throwable = null;
                try {
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    Throwable throwable2 = null;
                    try {
                        message.getThrowable().printStackTrace(printWriter);
                        printWriter.flush();
                        returnLog.append(stringWriter.toString()).append("\n");
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (printWriter == null) continue;
                        if (throwable2 != null) {
                            try {
                                printWriter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        printWriter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stringWriter == null) continue;
                    if (throwable != null) {
                        try {
                            stringWriter.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stringWriter.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (returnLog.length() > 10000000) {
            returnLog.setLength(10000000);
        }
        return returnLog.toString();
    }

    public void addLog(BufferedLogMessage log) {
        this.log.add(log);
    }

    public static class BufferedLogMessage {
        private Date timestamp = new Date();
        private Level level;
        private Class location;
        private String message;
        private Throwable throwable;

        public BufferedLogMessage(Level level, Class location, String message, Throwable throwable) {
            this.location = location;
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public Level getLevel() {
            return this.level;
        }

        public Class getLocation() {
            return this.location;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

