/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.TestNGException;
import org.testng.collections.Lists;

public class PoolService<FutureType> {
    private final ExecutorCompletionService<FutureType> m_completionService;
    private final ExecutorService m_executor;

    public PoolService(int n) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "TestNG-PoolService-" + this.threadNumber.getAndIncrement());
            }
        };
        this.m_executor = Executors.newFixedThreadPool(n, threadFactory);
        this.m_completionService = new ExecutorCompletionService(this.m_executor);
    }

    public List<FutureType> submitTasksAndWait(List<? extends Callable<FutureType>> list) {
        List<Future> list2 = Lists.newArrayList(list.size());
        for (Callable<FutureType> object : list) {
            list2.add(this.m_completionService.submit(object));
        }
        List list3 = Lists.newArrayList(list2.size());
        for (Future future : list2) {
            try {
                list3.add(future.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new TestNGException(exception);
            }
        }
        this.m_executor.shutdown();
        return list3;
    }
}

