/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.atomic.AsyncCounter;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.blocks.atomic.CounterFunction;
import org.jgroups.blocks.atomic.CounterView;
import org.jgroups.blocks.atomic.SyncCounter;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.CompletableFutures;
import org.jgroups.util.Owner;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

@MBean(description="Protocol to maintain distributed atomic counters")
public class COUNTER
extends Protocol {
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong();
    private static final RequestType[] REQUEST_TYPES_CACHED = RequestType.values();
    private static final ResponseType[] RESPONSE_TYPES_CACHED = ResponseType.values();
    @Property(description="Bypasses message bundling if true")
    protected boolean bypass_bundling;
    @Property(description="Request timeouts (in ms). If the timeout elapses, a TimeoutException will be thrown", type=AttributeType.TIME)
    protected long timeout = 60000L;
    @Property(description="Number of milliseconds to wait for reconciliation responses from all current members", type=AttributeType.TIME)
    protected long reconciliation_timeout = 10000L;
    @Property(description="Number of backup coordinators. Modifications are asynchronously sent to all backup coordinators")
    protected int num_backups = 1;
    protected boolean discard_requests = false;
    protected View view;
    protected Address coord;
    protected List<Address> backup_coords = null;
    protected Future<?> reconciliation_task_future;
    protected ReconciliationTask reconciliation_task;
    protected final Map<String, VersionedValue> counters = Util.createConcurrentMap(20);
    protected final Map<Owner, RequestCompletableFuture<?>> pending_requests = Util.createConcurrentMap(20);
    protected static final byte REQUEST = 1;
    protected static final byte RESPONSE = 2;
    private TP transport;

    public boolean getBypassBundling() {
        return this.bypass_bundling;
    }

    public COUNTER setBypassBundling(boolean bypass_bundling) {
        this.bypass_bundling = bypass_bundling;
        return this;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : null;
    }

    @ManagedAttribute(description="List of the backup coordinator (null if num_backups <= 0")
    public String getBackupCoords() {
        return this.backup_coords != null ? this.backup_coords.toString() : "null";
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.transport = this.getTransport();
    }

    @Deprecated
    public Counter getOrCreateCounter(String name, long initial_value) {
        CounterImpl counter = CompletableFutures.join(this.doGetOrCreateCounter(name, initial_value));
        return counter.sync;
    }

    public CompletionStage<AsyncCounter> getOrCreateAsyncCounter(String name, long initial_value) {
        return this.doGetOrCreateCounter(name, initial_value).thenApply(Function.identity());
    }

    private CompletionStage<CounterImpl> doGetOrCreateCounter(String name, long initial_value) {
        Objects.requireNonNull(name);
        if (this.local_addr == null) {
            throw new IllegalStateException("the channel needs to be connected before creating or getting a counter");
        }
        if (this.counters.containsKey(name)) {
            return CompletableFuture.completedFuture(new CounterImpl(name));
        }
        Owner owner = this.getOwner();
        GetOrCreateRequest req = new GetOrCreateRequest(owner, name, initial_value);
        CompletableFuture rsp = this.sendRequestToCoordinator(owner, req);
        return rsp.thenApply(aLong -> new CounterImpl(name));
    }

    public void deleteCounter(String name) {
        Owner owner = this.getOwner();
        DeleteRequest req = new DeleteRequest(owner, name);
        this.sendRequest(this.coord, req);
        if (!this.local_addr.equals(this.coord)) {
            this.counters.remove(name);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.arg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        CounterHeader hdr = (CounterHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        try {
            assert (msg.hasArray());
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(msg.getArray(), msg.getOffset(), msg.getLength()));
            switch (in.readByte()) {
                case 1: {
                    Request req = COUNTER.requestFromDataInput(in);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[" + String.valueOf(this.local_addr) + "] <-- [" + String.valueOf(msg.getSrc()) + "] " + String.valueOf(req));
                    }
                    req.execute(this, msg.getSrc());
                    break;
                }
                case 2: {
                    Response<?> rsp = COUNTER.responseFromDataInput(in);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[" + String.valueOf(this.local_addr) + "] <-- [" + String.valueOf(msg.getSrc()) + "] " + String.valueOf(rsp));
                    }
                    this.handleResponse(rsp, msg.getSrc());
                    break;
                }
                default: {
                    this.log.error(Util.getMessage("ReceivedObjectIsNeitherARequestNorAResponse"));
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedHandlingMessage"), ex);
        }
        return null;
    }

    protected VersionedValue getCounter(String name) {
        VersionedValue val = this.counters.get(name);
        if (val == null) {
            throw new IllegalStateException("counter \"" + name + "\" not found");
        }
        return val;
    }

    protected void handleResponse(Response rsp, Address sender) {
        if (rsp instanceof ReconcileResponse) {
            this.handleReconcileResponse((ReconcileResponse)rsp, sender);
            return;
        }
        RequestCompletableFuture<?> cf = this.pending_requests.remove(rsp.getOwner());
        if (cf == null) {
            this.log.warn("response for " + String.valueOf(rsp.getOwner()) + " didn't have an entry");
            return;
        }
        rsp.complete(cf);
    }

    private void handleReconcileResponse(ReconcileResponse rsp, Address sender) {
        if (this.log.isTraceEnabled() && rsp.names != null && rsp.names.length > 0) {
            this.log.trace("[" + String.valueOf(this.local_addr) + "] <-- [" + String.valueOf(sender) + "] RECONCILE-RSP: " + COUNTER.dump(rsp.names, rsp.values, rsp.versions));
        }
        if (this.reconciliation_task != null) {
            this.reconciliation_task.add(rsp, sender);
        }
    }

    @ManagedOperation(description="Dumps all counters")
    public String printCounters() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, VersionedValue> entry : this.counters.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Dumps all pending requests")
    public String dumpPendingRequests() {
        StringBuilder sb = new StringBuilder();
        for (RequestCompletableFuture<?> cf : this.pending_requests.values()) {
            Request tmp = cf.getRequest();
            sb.append(tmp).append('(').append(tmp.getClass().getCanonicalName()).append(") ");
        }
        return sb.toString();
    }

    protected void handleView(View view) {
        this.view = view;
        if (this.log.isDebugEnabled()) {
            this.log.debug("view=" + String.valueOf(view));
        }
        List<Address> members = view.getMembers();
        Address old_coord = this.coord;
        if (!members.isEmpty()) {
            this.coord = members.get(0);
        }
        if (Objects.equals(this.coord, this.local_addr)) {
            ArrayList<Address> old_backups = this.backup_coords != null ? new ArrayList<Address>(this.backup_coords) : null;
            this.backup_coords = new CopyOnWriteArrayList<Address>(Util.pickNext(members, this.local_addr, this.num_backups));
            List<Address> new_backups = Util.newElements(old_backups, this.backup_coords);
            for (Address new_backup : new_backups) {
                for (Map.Entry<String, VersionedValue> entry : this.counters.entrySet()) {
                    UpdateRequest update = new UpdateRequest(entry.getKey(), entry.getValue().value, entry.getValue().version);
                    this.sendRequest(new_backup, update);
                }
            }
        } else {
            this.backup_coords = null;
        }
        if (old_coord != null && this.coord != null && !old_coord.equals(this.coord) && this.local_addr.equals(this.coord)) {
            this.discard_requests = true;
            this.startReconciliationTask();
        }
    }

    protected Owner getOwner() {
        return new Owner(this.local_addr, REQUEST_ID_GENERATOR.incrementAndGet());
    }

    protected void updateBackups(String name, long[] versionedValue) {
        if (this.backup_coords == null || this.backup_coords.isEmpty()) {
            return;
        }
        UpdateRequest req = new UpdateRequest(name, versionedValue[0], versionedValue[1]);
        try {
            ByteArray buffer = COUNTER.requestToBuffer(req);
            for (Address dst : this.backup_coords) {
                this.logSending(dst, req);
                this.send(dst, buffer);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + String.valueOf(req) + " to backup coordinator(s):" + String.valueOf(ex));
        }
    }

    protected void sendRequest(Address dest, Request req) {
        try {
            ByteArray buffer = COUNTER.requestToBuffer(req);
            this.logSending(dest, req);
            this.send(dest, buffer);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + String.valueOf(req) + " request: " + String.valueOf(ex));
        }
    }

    protected void sendResponse(Address dest, Response<?> rsp) {
        try {
            ByteArray buffer = COUNTER.responseToBuffer(rsp);
            this.logSending(dest, rsp);
            this.send(dest, buffer);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + String.valueOf(rsp) + " message to " + String.valueOf(dest) + ": " + String.valueOf(ex));
        }
    }

    protected void send(Address dest, ByteArray buffer) {
        try {
            Message rsp_msg = new BytesMessage(dest, buffer).putHeader(this.id, new CounterHeader());
            if (this.bypass_bundling) {
                rsp_msg.setFlag(Message.Flag.DONT_BUNDLE);
            }
            this.down_prot.down(rsp_msg);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSendingMessageTo") + String.valueOf(dest) + ": " + String.valueOf(ex));
        }
    }

    private void logSending(Address dst, Object data) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("[" + String.valueOf(this.local_addr) + "] --> [" + String.valueOf(dst == null ? "ALL" : dst) + "]: " + String.valueOf(data));
        }
    }

    protected void sendCounterNotFoundExceptionResponse(Address dest, Owner owner, String counter_name) {
        ExceptionResponse rsp = new ExceptionResponse(owner, "counter \"" + counter_name + "\" not found");
        this.sendResponse(dest, rsp);
    }

    private <T> T updateCounter(ResponseData<T> responseData) {
        if (!this.coord.equals(this.local_addr)) {
            this.counters.compute(responseData.counterName, responseData);
        }
        return responseData.returnValue;
    }

    protected static ByteArray requestToBuffer(Request req) throws Exception {
        return COUNTER.streamableToBuffer((byte)1, (byte)req.getRequestType().ordinal(), req);
    }

    protected static ByteArray responseToBuffer(Response<?> rsp) throws Exception {
        return COUNTER.streamableToBuffer((byte)2, (byte)rsp.getResponseType().ordinal(), rsp);
    }

    protected static ByteArray streamableToBuffer(byte req_or_rsp, byte type, Streamable obj) throws Exception {
        int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() : 100;
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size);
        out.writeByte(req_or_rsp);
        out.writeByte(type);
        obj.writeTo(out);
        return new ByteArray(out.buffer(), 0, out.position());
    }

    protected static Request requestFromDataInput(DataInput in) throws Exception {
        Request retval = REQUEST_TYPES_CACHED[in.readByte()].create();
        retval.readFrom(in);
        return retval;
    }

    protected static Response<?> responseFromDataInput(DataInput in) throws Exception {
        Response<?> retval = RESPONSE_TYPES_CACHED[in.readByte()].create();
        retval.readFrom(in);
        return retval;
    }

    protected synchronized void startReconciliationTask() {
        if (this.reconciliation_task_future == null || this.reconciliation_task_future.isDone()) {
            this.reconciliation_task = new ReconciliationTask();
            this.reconciliation_task_future = this.transport.getTimer().schedule(this.reconciliation_task, 0L, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconciliationTask() {
        if (this.reconciliation_task_future != null) {
            this.reconciliation_task_future.cancel(true);
            if (this.reconciliation_task != null) {
                this.reconciliation_task.cancel();
            }
            this.reconciliation_task_future = null;
        }
    }

    protected static void writeReconciliation(DataOutput out, String[] names, long[] values, long[] versions) throws IOException {
        if (names == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(names.length);
        for (String name : names) {
            Bits.writeString(name, out);
        }
        for (long value : values) {
            Bits.writeLongCompressed(value, out);
        }
        for (long version : versions) {
            Bits.writeLongCompressed(version, out);
        }
    }

    protected static String[] readReconciliationNames(DataInput in, int len) throws IOException {
        String[] retval = new String[len];
        for (int i = 0; i < len; ++i) {
            retval[i] = Bits.readString(in);
        }
        return retval;
    }

    protected static long[] readReconciliationLongs(DataInput in, int len) throws IOException {
        long[] retval = new long[len];
        for (int i = 0; i < len; ++i) {
            retval[i] = Bits.readLongCompressed(in);
        }
        return retval;
    }

    protected static String dump(String[] names, long[] values, long[] versions) {
        StringBuilder sb = new StringBuilder();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                sb.append(names[i]).append(": ").append(values[i]).append(" (").append(versions[i]).append(")\n");
            }
        }
        return sb.toString();
    }

    private <T> CompletableFuture<T> sendRequestToCoordinator(Owner owner, Request request) {
        RequestCompletableFuture cf = new RequestCompletableFuture(request);
        this.pending_requests.put(owner, cf);
        this.sendRequest(this.coord, request);
        return cf.orTimeout(this.timeout, TimeUnit.MILLISECONDS).thenApply(this::updateCounter);
    }

    private boolean skipRequest() {
        return !this.local_addr.equals(this.coord) || this.discard_requests;
    }

    private void traceResending(Request request) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("[" + String.valueOf(this.local_addr) + "] --> [" + String.valueOf(this.coord) + "] resending " + String.valueOf(request));
        }
    }

    protected class CounterImpl
    implements AsyncCounter {
        protected final String name;
        final SyncCounterImpl sync;

        protected CounterImpl(String name) {
            this.name = name;
            this.sync = new SyncCounterImpl(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public CompletableFuture<Void> set(long new_value) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                VersionedValue val = COUNTER.this.getCounter(this.name);
                long[] result = val.set(new_value);
                COUNTER.this.updateBackups(this.name, result);
                return CompletableFutures.completedNull();
            }
            Owner owner = COUNTER.this.getOwner();
            SetRequest req = new SetRequest(owner, this.name, new_value);
            return COUNTER.this.sendRequestToCoordinator(owner, req).thenAccept(CompletableFutures.voidConsumer());
        }

        public CompletableFuture<Long> compareAndSwap(long expect, long update) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                VersionedValue val = COUNTER.this.getCounter(this.name);
                long retval = val.compareAndSwap(expect, update)[0];
                COUNTER.this.updateBackups(this.name, val.snapshot());
                return CompletableFuture.completedFuture(retval);
            }
            Owner owner = COUNTER.this.getOwner();
            CompareAndSetRequest req = new CompareAndSetRequest(owner, this.name, expect, update);
            return COUNTER.this.sendRequestToCoordinator(owner, req);
        }

        public CompletableFuture<Long> addAndGet(long delta) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                VersionedValue val = COUNTER.this.getCounter(this.name);
                long[] result = val.addAndGet(delta);
                if (delta != 0L) {
                    COUNTER.this.updateBackups(this.name, result);
                }
                return CompletableFuture.completedFuture(result[0]);
            }
            Owner owner = COUNTER.this.getOwner();
            AddAndGetRequest req = new AddAndGetRequest(owner, this.name, delta);
            return COUNTER.this.sendRequestToCoordinator(owner, req);
        }

        @Override
        public <T extends Streamable> CompletionStage<T> update(CounterFunction<T> updateFunction) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                try {
                    VersionedValue val = COUNTER.this.getCounter(this.name);
                    UpdateResult<T> res = val.update(updateFunction);
                    if (res.updated) {
                        COUNTER.this.updateBackups(this.name, res.snapshot);
                    }
                    return CompletableFuture.completedFuture(res.result);
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
            }
            Owner owner = COUNTER.this.getOwner();
            UpdateFunctionRequest<T> req = new UpdateFunctionRequest<T>(owner, this.name, updateFunction);
            return COUNTER.this.sendRequestToCoordinator(owner, req);
        }

        @Override
        public SyncCounter sync() {
            return this.sync;
        }

        public String toString() {
            VersionedValue val = COUNTER.this.counters.get(this.name);
            return val != null ? val.toString() : "n/a";
        }
    }

    private static class SyncCounterImpl
    implements Counter {
        private final AsyncCounter counter;

        private SyncCounterImpl(AsyncCounter counter) {
            this.counter = counter;
        }

        @Override
        public String getName() {
            return this.counter.getName();
        }

        @Override
        public long get() {
            return CompletableFutures.join(this.counter.get());
        }

        @Override
        public void set(long new_value) {
            CompletableFutures.join(this.counter.set(new_value));
        }

        @Override
        public long compareAndSwap(long expect, long update) {
            return CompletableFutures.join(this.counter.compareAndSwap(expect, update));
        }

        @Override
        public long addAndGet(long delta) {
            return CompletableFutures.join(this.counter.addAndGet(delta));
        }

        @Override
        public <T extends Streamable> T update(CounterFunction<T> updateFunction) {
            return (T)((Streamable)CompletableFutures.join(this.counter.update(updateFunction)));
        }

        @Override
        public AsyncCounter async() {
            return this.counter;
        }

        public String toString() {
            return this.counter != null ? this.counter.toString() : null;
        }
    }

    protected static class GetOrCreateRequest
    extends SimpleRequest {
        protected long initial_value;

        protected GetOrCreateRequest() {
        }

        GetOrCreateRequest(Owner owner, String name, long initial_value) {
            super(owner, name);
            this.initial_value = initial_value;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.initial_value = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.initial_value, out);
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.GET_OR_CREATE;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            VersionedValue new_val = new VersionedValue(this.initial_value);
            VersionedValue val = protocol.counters.putIfAbsent(this.name, new_val);
            if (val == null) {
                val = new_val;
            }
            long[] result = val.snapshot();
            ValueResponse rsp = new ValueResponse(this.owner, result);
            protocol.sendResponse(sender, rsp);
            protocol.updateBackups(this.name, result);
        }
    }

    protected static interface Request
    extends Streamable {
        public String getCounterName();

        public RequestType getRequestType();

        public void execute(COUNTER var1, Address var2);
    }

    protected static class DeleteRequest
    extends SimpleRequest {
        protected DeleteRequest() {
        }

        protected DeleteRequest(Owner owner, String name) {
            super(owner, name);
        }

        @Override
        public String toString() {
            return "DeleteRequest: " + super.toString();
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.DELETE;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            protocol.counters.remove(this.name);
        }
    }

    public static class CounterHeader
    extends Header {
        @Override
        public Supplier<? extends Header> create() {
            return CounterHeader::new;
        }

        @Override
        public short getMagicId() {
            return 74;
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) {
        }

        @Override
        public void readFrom(DataInput in) {
        }
    }

    private static abstract class Response<T>
    implements Streamable {
        private Owner owner;

        Response() {
        }

        Response(Owner owner) {
            this.owner = owner;
        }

        abstract ResponseType getResponseType();

        abstract void complete(RequestCompletableFuture<T> var1);

        final Owner getOwner() {
            return this.owner;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.owner.writeTo(out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.owner = new Owner();
            this.owner.readFrom(in);
        }
    }

    protected static class VersionedValue {
        protected long value;
        protected long version = 1L;

        protected VersionedValue(long value) {
            this.value = value;
        }

        protected VersionedValue(long value, long version) {
            this.value = value;
            this.version = version;
        }

        protected synchronized long[] addAndGet(long num) {
            long[] lArray;
            if (num == 0L) {
                long[] lArray2 = new long[2];
                lArray2[0] = this.value;
                lArray = lArray2;
                lArray2[1] = this.version;
            } else {
                long[] lArray3 = new long[2];
                lArray3[0] = this.value += num;
                lArray = lArray3;
                lArray3[1] = ++this.version;
            }
            return lArray;
        }

        protected synchronized long[] set(long value) {
            this.value = value;
            return new long[]{this.value, ++this.version};
        }

        protected synchronized long[] compareAndSwap(long expected, long update) {
            long oldValue = this.value;
            if (oldValue == expected) {
                this.value = update;
            }
            return new long[]{oldValue, ++this.version};
        }

        protected synchronized void updateIfBigger(long value, long version) {
            if (version > this.version) {
                this.version = version;
                this.value = value;
            }
        }

        synchronized long[] snapshot() {
            return new long[]{this.value, this.version};
        }

        synchronized <T extends Streamable> UpdateResult<T> update(CounterFunction<T> updateFunction) {
            CounterViewImpl view = new CounterViewImpl(this.value);
            Streamable res = (Streamable)updateFunction.apply(view);
            boolean updated = false;
            if (this.value != view.value) {
                this.value = view.value;
                updated = true;
            }
            return new UpdateResult<Streamable>(updated, res, new long[]{this.value, ++this.version});
        }

        public String toString() {
            return this.value + " (version=" + this.version + ")";
        }
    }

    protected static class ReconcileResponse
    extends Response<Void> {
        protected String[] names;
        protected long[] values;
        protected long[] versions;

        protected ReconcileResponse() {
        }

        protected ReconcileResponse(String[] names, long[] values, long[] versions) {
            this.names = names;
            this.values = values;
            this.versions = versions;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            COUNTER.writeReconciliation(out, this.names, this.values, this.versions);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            this.names = COUNTER.readReconciliationNames(in, len);
            this.values = COUNTER.readReconciliationLongs(in, len);
            this.versions = COUNTER.readReconciliationLongs(in, len);
        }

        public String toString() {
            int num = this.names != null ? this.names.length : 0;
            return "ReconcileResponse (" + num + ") entries";
        }

        @Override
        public ResponseType getResponseType() {
            return ResponseType.RECONCILE;
        }

        @Override
        void complete(RequestCompletableFuture<Void> cf) {
        }
    }

    private static class RequestCompletableFuture<T>
    extends CompletableFuture<ResponseData<T>> {
        final Request request;

        private RequestCompletableFuture(Request request) {
            this.request = request;
        }

        Request getRequest() {
            return this.request;
        }

        void requestCompleted(long value, long version, T returnValue) {
            this.complete(new ResponseData<T>(this.request.getCounterName(), value, version, returnValue));
        }

        void requestFailed(String errorMessage) {
            this.completeExceptionally(new Throwable(errorMessage));
        }
    }

    protected class ReconciliationTask
    implements Runnable {
        protected ResponseCollector<ReconcileResponse> responses;

        protected ReconciliationTask() {
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            finally {
                COUNTER.this.discard_requests = false;
            }
            ResendPendingRequests req = new ResendPendingRequests();
            COUNTER.this.sendRequest(null, req);
        }

        protected void _run() {
            HashMap<String, VersionedValue> copy = new HashMap<String, VersionedValue>(COUNTER.this.counters);
            int len = copy.size();
            String[] names = new String[len];
            long[] values = new long[len];
            long[] versions = new long[len];
            int index = 0;
            for (Map.Entry entry : copy.entrySet()) {
                names[index] = (String)entry.getKey();
                values[index] = ((VersionedValue)entry.getValue()).value;
                versions[index] = ((VersionedValue)entry.getValue()).version;
                ++index;
            }
            ArrayList<Address> targets = new ArrayList<Address>(COUNTER.this.view.getMembers());
            targets.remove(COUNTER.this.local_addr);
            this.responses = new ResponseCollector(targets);
            ReconcileRequest req = new ReconcileRequest(names, values, versions);
            COUNTER.this.sendRequest(null, req);
            this.responses.waitForAllResponses(COUNTER.this.reconciliation_timeout);
            Map<Address, ReconcileResponse> reconcile_results = this.responses.getResults();
            for (Map.Entry<Address, ReconcileResponse> entry : reconcile_results.entrySet()) {
                ReconcileResponse rsp;
                if (entry.getKey().equals(COUNTER.this.local_addr) || (rsp = entry.getValue()) == null || rsp.names == null) continue;
                for (int i = 0; i < rsp.names.length; ++i) {
                    String counter_name = rsp.names[i];
                    long version = rsp.versions[i];
                    long value = rsp.values[i];
                    VersionedValue my_value = COUNTER.this.counters.get(counter_name);
                    if (my_value == null) {
                        COUNTER.this.counters.put(counter_name, new VersionedValue(value, version));
                        continue;
                    }
                    my_value.updateIfBigger(value, version);
                }
            }
        }

        public void add(ReconcileResponse rsp, Address sender) {
            if (this.responses != null) {
                this.responses.add(sender, rsp);
            }
        }

        protected void cancel() {
            if (this.responses != null) {
                this.responses.reset();
            }
        }

        public String toString() {
            return COUNTER.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected static class UpdateRequest
    implements Request,
    BiFunction<String, VersionedValue, VersionedValue> {
        protected String name;
        protected long value;
        protected long version;

        protected UpdateRequest() {
        }

        protected UpdateRequest(String name, long value, long version) {
            this.name = name;
            this.value = value;
            this.version = version;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.name, out);
            Bits.writeLongCompressed(this.value, out);
            Bits.writeLongCompressed(this.version, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.name = Bits.readString(in);
            this.value = Bits.readLongCompressed(in);
            this.version = Bits.readLongCompressed(in);
        }

        public String toString() {
            return "UpdateRequest(" + this.name + ": " + this.value + " (" + this.version + ")";
        }

        @Override
        public String getCounterName() {
            return this.name;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.UPDATE;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            protocol.counters.compute(this.name, this);
        }

        @Override
        public VersionedValue apply(String name, VersionedValue versionedValue) {
            if (versionedValue == null) {
                versionedValue = new VersionedValue(this.value, this.version);
            } else {
                versionedValue.updateIfBigger(this.value, this.version);
            }
            return versionedValue;
        }
    }

    protected static class ExceptionResponse
    extends Response<Void> {
        protected String error_message;

        protected ExceptionResponse() {
        }

        protected ExceptionResponse(Owner owner, String error_message) {
            super(owner);
            this.error_message = error_message;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.error_message = Bits.readString(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeString(this.error_message, out);
        }

        public String toString() {
            return "ExceptionResponse: " + super.toString();
        }

        @Override
        public ResponseType getResponseType() {
            return ResponseType.EXCEPTION;
        }

        @Override
        void complete(RequestCompletableFuture<Void> cf) {
            cf.requestFailed(this.error_message);
        }
    }

    private static class ResponseData<T>
    implements BiFunction<String, VersionedValue, VersionedValue> {
        private final String counterName;
        private final long value;
        private final long version;
        private final T returnValue;

        private ResponseData(String counterName, long value, long version, T returnValue) {
            this.counterName = counterName;
            this.value = value;
            this.version = version;
            this.returnValue = returnValue;
        }

        @Override
        public VersionedValue apply(String s, VersionedValue versionedValue) {
            if (versionedValue == null) {
                versionedValue = new VersionedValue(this.value, this.version);
            } else {
                versionedValue.updateIfBigger(this.value, this.version);
            }
            return versionedValue;
        }
    }

    protected static enum RequestType {
        GET_OR_CREATE{

            @Override
            Request create() {
                return new GetOrCreateRequest();
            }
        }
        ,
        DELETE{

            @Override
            Request create() {
                return new DeleteRequest();
            }
        }
        ,
        SET{

            @Override
            Request create() {
                return new SetRequest();
            }
        }
        ,
        COMPARE_AND_SET{

            @Override
            Request create() {
                return new CompareAndSetRequest();
            }
        }
        ,
        ADD_AND_GET{

            @Override
            Request create() {
                return new AddAndGetRequest();
            }
        }
        ,
        UPDATE{

            @Override
            Request create() {
                return new UpdateRequest();
            }
        }
        ,
        RECONCILE{

            @Override
            Request create() {
                return new ReconcileRequest();
            }
        }
        ,
        RESEND_PENDING_REQUESTS{

            @Override
            Request create() {
                return new ResendPendingRequests();
            }
        }
        ,
        UPDATE_FUNCTION{

            @Override
            Request create() {
                return new UpdateFunctionRequest();
            }
        };


        abstract Request create();
    }

    protected static enum ResponseType {
        VALUE{

            Response<Long> create() {
                return new ValueResponse();
            }
        }
        ,
        EXCEPTION{

            Response<Void> create() {
                return new ExceptionResponse();
            }
        }
        ,
        RECONCILE{

            Response<Void> create() {
                return new ReconcileResponse();
            }
        }
        ,
        UPDATE_FUNCTION{

            @Override
            Response<?> create() {
                return new UpdateFunctionResponse();
            }
        };


        abstract Response<?> create();
    }

    private static class UpdateResult<T extends Streamable> {
        final boolean updated;
        final T result;
        final long[] snapshot;

        private UpdateResult(boolean updated, T result, long[] snapshot) {
            this.updated = updated;
            this.result = result;
            this.snapshot = snapshot;
        }
    }

    private static class CounterViewImpl
    implements CounterView {
        private long value;

        private CounterViewImpl(long value) {
            this.value = value;
        }

        @Override
        public long get() {
            return this.value;
        }

        @Override
        public void set(long value) {
            this.value = value;
        }
    }

    private static class UpdateFunctionResponse<T extends Streamable>
    extends Response<T> {
        private long value;
        private long version;
        private T response;

        UpdateFunctionResponse() {
        }

        UpdateFunctionResponse(Owner owner, UpdateResult<T> result) {
            super(owner);
            this.value = result.snapshot[0];
            this.version = result.snapshot[1];
            this.response = result.result;
        }

        @Override
        public ResponseType getResponseType() {
            return ResponseType.UPDATE_FUNCTION;
        }

        @Override
        void complete(RequestCompletableFuture<T> completableFuture) {
            completableFuture.requestCompleted(this.value, this.version, this.response);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.response = Util.readGenericStreamable(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Util.writeGenericStreamable(this.response, out);
        }

        public String toString() {
            return "UpdateFunctionResponse{response=" + String.valueOf(this.response) + ", value=" + this.value + ", version=" + this.version + ", owner=" + String.valueOf(this.getOwner()) + "}";
        }
    }

    protected static class ValueResponse
    extends Response<Long> {
        protected long result;
        protected long version;

        protected ValueResponse() {
        }

        ValueResponse(Owner owner, long[] versionedValue) {
            this(owner, versionedValue[0], versionedValue[1]);
        }

        protected ValueResponse(Owner owner, long result, long version) {
            super(owner);
            this.result = result;
            this.version = version;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.result = Bits.readLongCompressed(in);
            this.version = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.result, out);
            Bits.writeLongCompressed(this.version, out);
        }

        public String toString() {
            return "ValueResponse(" + this.result + ")";
        }

        @Override
        public ResponseType getResponseType() {
            return ResponseType.VALUE;
        }

        @Override
        void complete(RequestCompletableFuture<Long> cf) {
            cf.requestCompleted(this.result, this.version, this.result);
        }
    }

    private static class UpdateFunctionRequest<T extends Streamable>
    extends SimpleRequest {
        CounterFunction<T> updateFunction;

        UpdateFunctionRequest() {
        }

        UpdateFunctionRequest(Owner owner, String name, CounterFunction<T> updateFunction) {
            super(owner, name);
            this.updateFunction = updateFunction;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.UPDATE_FUNCTION;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            VersionedValue val = protocol.counters.get(this.name);
            if (val == null) {
                protocol.sendCounterNotFoundExceptionResponse(sender, this.owner, this.name);
                return;
            }
            UpdateResult<T> result = val.update(this.updateFunction);
            UpdateFunctionResponse<T> rsp = new UpdateFunctionResponse<T>(this.owner, result);
            protocol.sendResponse(sender, rsp);
            if (result.updated) {
                protocol.updateBackups(this.name, result.snapshot);
            }
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Util.writeGenericStreamable(this.updateFunction, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.updateFunction = (CounterFunction)Util.readGenericStreamable(in);
        }
    }

    protected static class ReconcileRequest
    implements Request {
        protected String[] names;
        protected long[] values;
        protected long[] versions;

        protected ReconcileRequest() {
        }

        protected ReconcileRequest(String[] names, long[] values, long[] versions) {
            this.names = names;
            this.values = values;
            this.versions = versions;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            COUNTER.writeReconciliation(out, this.names, this.values, this.versions);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            this.names = COUNTER.readReconciliationNames(in, len);
            this.values = COUNTER.readReconciliationLongs(in, len);
            this.versions = COUNTER.readReconciliationLongs(in, len);
        }

        public String toString() {
            return "ReconcileRequest (" + this.names.length + ") entries";
        }

        @Override
        public String getCounterName() {
            return null;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.RECONCILE;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (sender.equals(protocol.local_addr)) {
                return;
            }
            HashMap<String, VersionedValue> map = new HashMap<String, VersionedValue>(protocol.counters);
            if (this.names != null) {
                for (int i = 0; i < this.names.length; ++i) {
                    String counter_name = this.names[i];
                    long version = this.versions[i];
                    VersionedValue my_value = (VersionedValue)map.get(counter_name);
                    if (my_value == null || my_value.version > version) continue;
                    map.remove(counter_name);
                }
            }
            int len = map.size();
            String[] names = new String[len];
            long[] values = new long[len];
            long[] versions = new long[len];
            int index = 0;
            for (Map.Entry entry : map.entrySet()) {
                names[index] = (String)entry.getKey();
                values[index] = ((VersionedValue)entry.getValue()).value;
                versions[index] = ((VersionedValue)entry.getValue()).version;
                ++index;
            }
            ReconcileResponse rsp = new ReconcileResponse(names, values, versions);
            protocol.sendResponse(sender, rsp);
        }
    }

    protected static class CompareAndSetRequest
    extends SimpleRequest {
        protected long expected;
        protected long update;

        protected CompareAndSetRequest() {
        }

        protected CompareAndSetRequest(Owner owner, String name, long expected, long update) {
            super(owner, name);
            this.expected = expected;
            this.update = update;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.expected = Bits.readLongCompressed(in);
            this.update = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.expected, out);
            Bits.writeLongCompressed(this.update, out);
        }

        @Override
        public String toString() {
            return super.toString() + ", expected=" + this.expected + ", update=" + this.update;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.COMPARE_AND_SET;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            VersionedValue val = protocol.counters.get(this.name);
            if (val == null) {
                protocol.sendCounterNotFoundExceptionResponse(sender, this.owner, this.name);
                return;
            }
            long[] result = val.compareAndSwap(this.expected, this.update);
            ValueResponse rsp = new ValueResponse(this.owner, result);
            protocol.sendResponse(sender, rsp);
            protocol.updateBackups(this.name, val.snapshot());
        }
    }

    protected static class SetRequest
    extends SimpleRequest {
        protected long value;

        protected SetRequest() {
        }

        protected SetRequest(Owner owner, String name, long value) {
            super(owner, name);
            this.value = value;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.value = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.value, out);
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.value;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.SET;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            VersionedValue val = protocol.counters.get(this.name);
            if (val == null) {
                protocol.sendCounterNotFoundExceptionResponse(sender, this.owner, this.name);
                return;
            }
            long[] result = val.set(this.value);
            ValueResponse rsp = new ValueResponse(this.owner, result);
            protocol.sendResponse(sender, rsp);
            protocol.updateBackups(this.name, result);
        }
    }

    protected static class AddAndGetRequest
    extends SetRequest {
        protected AddAndGetRequest() {
        }

        protected AddAndGetRequest(Owner owner, String name, long value) {
            super(owner, name, value);
        }

        @Override
        public String toString() {
            return "AddAndGetRequest: " + super.toString();
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.ADD_AND_GET;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            if (protocol.skipRequest()) {
                return;
            }
            VersionedValue val = protocol.counters.get(this.name);
            if (val == null) {
                protocol.sendCounterNotFoundExceptionResponse(sender, this.owner, this.name);
                return;
            }
            long[] result = val.addAndGet(this.value);
            ValueResponse rsp = new ValueResponse(this.owner, result);
            protocol.sendResponse(sender, rsp);
            if (this.value != 0L) {
                protocol.updateBackups(this.name, result);
            }
        }
    }

    protected static class ResendPendingRequests
    implements Request {
        protected ResendPendingRequests() {
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
        }

        public String toString() {
            return "ResendPendingRequests";
        }

        @Override
        public String getCounterName() {
            return null;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.RESEND_PENDING_REQUESTS;
        }

        @Override
        public void execute(COUNTER protocol, Address sender) {
            for (RequestCompletableFuture<?> cf : protocol.pending_requests.values()) {
                Request request = cf.getRequest();
                protocol.traceResending(request);
                protocol.sendRequest(protocol.coord, request);
            }
        }
    }

    protected static abstract class SimpleRequest
    implements Request {
        protected Owner owner;
        protected String name;

        protected SimpleRequest() {
        }

        protected SimpleRequest(Owner owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.owner.writeTo(out);
            Bits.writeString(this.name, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.owner = new Owner();
            this.owner.readFrom(in);
            this.name = Bits.readString(in);
        }

        public String toString() {
            return String.valueOf(this.owner) + " [" + this.name + "]";
        }

        @Override
        public String getCounterName() {
            return this.name;
        }
    }
}

