/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v2.impl;

import ai.digital.deploy.permissions.api.rest.dto.EditRolePermissionsRequest;
import ai.digital.deploy.permissions.api.rest.dto.GetGlobalPermissionsForPrincipalNameDto;
import ai.digital.deploy.permissions.api.rest.dto.GetGlobalPermissionsForRoleIdDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@RestController
@RequestMapping(value={"/v2/permissions/global"})
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0004\t\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\u0006U\u0002!\ta\u001b\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\u00111%\u0012=uK:$W\rZ$m_\n\fG\u000eU3s[&\u001c8/[8og\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\n\u0015\u0005!\u0011.\u001c9m\u0015\tYA\"\u0001\u0002we)\u0011QBD\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012a\u00039fe6L7o]5p]NT!a\u0005\u000b\u0002\r\u0011,\u0007\u000f\\8z\u0015\t)b#A\u0004eS\u001eLG/\u00197\u000b\u0003]\t!!Y5\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002/\u001ddwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0011\u0003\u001d\u0019XM\u001d<jG\u0016L!AJ\u0012\u0003/\u001dcwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002*WA\u0011!\u0006A\u0007\u0002\u0011!)\u0001E\u0001a\u0001C\u0005yQ\rZ5u!\u0016\u0014X.[:tS>t7\u000fF\u0002/iA\u0003\"a\f\u001a\u000e\u0003AR!!\r\u0007\u0002\u0007\u0011$x.\u0003\u00024a\ta\"k\u001c7f/&$\bn\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\tR|\u0007\"B\u001b\u0004\u0001\u00041\u0014\u0001\u0003:pY\u0016t\u0015-\\3\u0011\u0005]rdB\u0001\u001d=!\tID$D\u0001;\u0015\tY\u0004$\u0001\u0004=e>|GOP\u0005\u0003{q\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Q\b\b\u0015\u0003i\t\u0003\"a\u0011(\u000e\u0003\u0011S!!\u0012$\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002H\u0011\u0006!!-\u001b8e\u0015\tI%*A\u0002xK\nT!a\u0013'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!T\u0001\u0004_J<\u0017BA(E\u00051\u0001\u0016\r\u001e5WCJL\u0017M\u00197f\u0011\u0015\t6\u00011\u0001S\u0003i)G-\u001b;S_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t%\u0016\fX/Z:u!\ty3+\u0003\u0002Ua\tQR\tZ5u%>dW\rU3s[&\u001c8/[8ogJ+\u0017/^3ti\"\u0012\u0001K\u0016\t\u0003\u0007^K!\u0001\u0017#\u0003\u0017I+\u0017/^3ti\n{G-\u001f\u0015\u0003!j\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\u0015Y\fG.\u001b3bi&|gNC\u0001`\u0003\u0015Q\u0017M^1y\u0013\t\tGLA\u0003WC2LG\r\u000b\u0003\u0004G\u001a<\u0007CA\"e\u0013\t)GI\u0001\u0007QCR\u001c\u0007.T1qa&tw-A\u0003wC2,X\rL\u0001iC\u0005I\u0017aC\u0018|e>dWMT1nKv\fQdZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:S_2,\u0017\n\u001a\u000b\u0003YV\u00042!\u001c:7\u001d\tq\u0007O\u0004\u0002:_&\tQ$\u0003\u0002r9\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005\u0011a\u0015n\u001d;\u000b\u0005Ed\u0002\"B\u0019\u0005\u0001\u00041\bCA\u0018x\u0013\tA\bG\u0001\u0011HKR<En\u001c2bYB+'/\\5tg&|gn\u001d$peJ{G.Z%e\tR|\u0007FA;[Q\u0011!1P\u001a@\u0011\u0005\rc\u0018BA?E\u0005)9U\r^'baBLgn\u001a\u0017\u0002\u007f\u0006\u0012\u0011\u0011A\u0001\n_m\u0014x\u000e\\3JIv\f\u0001eZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:Qe&t7-\u001b9bYR!\u0011qAA\u0007!\u00119\u0014\u0011\u0002\u001c\n\u0007\u0005-\u0001IA\u0002TKRDa!M\u0003A\u0002\u0005=\u0001cA\u0018\u0002\u0012%\u0019\u00111\u0003\u0019\u0003O\u001d+Go\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014\bK]5oG&\u0004\u0018\r\u001c(b[\u0016$Eo\u001c\u0015\u0004\u0003\u001bQ\u0006&B\u0003|M\u0006eAFAA\u000eC\t\ti\"\u0001\u000e0aJLgnY5qC2|3\u0010\u001d:j]\u000eL\u0007/\u00197OC6,W0A\u0005eK2,G/Z!mYR\u0011\u00111\u0005\t\u00047\u0005\u0015\u0012bAA\u00149\t!QK\\5uQ\u00191\u00111\u00064\u00022A\u00191)!\f\n\u0007\u0005=BIA\u0007EK2,G/Z'baBLgn\u001a\u0017\u0003\u0003g\t#!!\u000e\u0002\t=\nG\u000e\u001c\u0015\u0007\u0001\u0005eb-a\u0010\u0011\u0007\r\u000bY$C\u0002\u0002>\u0011\u0013aBU3rk\u0016\u001cH/T1qa&tw\r\f\u0002\u0002B\u0005\u0012\u00111I\u0001\u0017_Y\u0014t\u0006]3s[&\u001c8/[8og>:Gn\u001c2bY\"\u001a\u0001!a\u0012\u0011\u0007\r\u000bI%C\u0002\u0002L\u0011\u0013aBU3ti\u000e{g\u000e\u001e:pY2,'\u000f")
public class ExtendedGlobalPermissionsController {
    private final GlobalPermissionService globalPermissionService;

    @PatchMapping(value={"/{roleName}"})
    public RoleWithGlobalPermissionsDto editPermissions(@PathVariable String roleName, @Valid @RequestBody EditRolePermissionsRequest editRolePermissionsRequest) {
        Right right;
        Tuple2 tuple2;
        Either either = this.globalPermissionService.edit(roleName, CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.addedPermissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.removedPermissions()).asScala().toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List permissions = (List)tuple2._2();
            return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(permissions));
        }
        throw new MatchError((Object)either);
    }

    @GetMapping(value={"/{roleId}"})
    public List<String> getGlobalPermissionsForRoleId(@Valid GetGlobalPermissionsForRoleIdDto dto) {
        return this.globalPermissionService.getGlobalPermissionsForRoleId(UUID.fromString(dto.roleId()));
    }

    @GetMapping(value={"/principal/{principalName}"})
    public Set<String> getGlobalPermissionsForPrincipal(@Valid GetGlobalPermissionsForPrincipalNameDto dto) {
        return this.globalPermissionService.getGlobalPermissionsForPrincipal(dto.principalName());
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.globalPermissionService.removeAll();
    }

    public ExtendedGlobalPermissionsController(GlobalPermissionService globalPermissionService) {
        this.globalPermissionService = globalPermissionService;
    }
}

