/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameData;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventRenderer$;
import akka.http.impl.engine.ws.FrameHeader;
import akka.http.impl.engine.ws.FrameStart;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005}3Qa\u0003\u0007\u0003%YAQ!\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u00047\u0001\u0001\u0006Ia\r\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0011\u0019a\u0004\u0001)A\u0005s!9Q\b\u0001b\u0001\n\u0003r\u0004BB \u0001A\u0003%q\u0004C\u0003A\u0001\u0011\u0005\u0013\tC\u0003K\u0001\u0011%1\nC\u0003R\u0001\u0011%!K\u0001\nGe\u0006lW-\u0012<f]R\u0014VM\u001c3fe\u0016\u0014(BA\u0007\u000f\u0003\t98O\u0003\u0002\u0010!\u00051QM\\4j]\u0016T!!\u0005\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003'Q\tA\u0001\u001b;ua*\tQ#\u0001\u0003bW.\f7C\u0001\u0001\u0018!\rARdH\u0007\u00023)\u0011!dG\u0001\u0006gR\fw-\u001a\u0006\u00039Q\taa\u001d;sK\u0006l\u0017B\u0001\u0010\u001a\u0005)9%/\u00199i'R\fw-\u001a\t\u0005A\u0005\u001as%D\u0001\u001c\u0013\t\u00113DA\u0005GY><8\u000b[1qKB\u0011A%J\u0007\u0002\u0019%\u0011a\u0005\u0004\u0002\u000b\rJ\fW.Z#wK:$\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0015\u0003\u0011)H/\u001b7\n\u00051J#A\u0003\"zi\u0016\u001cFO]5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u00011!\t!\u0003!\u0001\u0002j]V\t1\u0007E\u0002!i\rJ!!N\u000e\u0003\u000b%sG.\u001a;\u0002\u0007%t\u0007%A\u0002pkR,\u0012!\u000f\t\u0004Ai:\u0013BA\u001e\u001c\u0005\u0019yU\u000f\u001e7fi\u0006!q.\u001e;!\u0003\u0015\u0019\b.\u00199f+\u0005y\u0012AB:iCB,\u0007%A\u0006de\u0016\fG/\u001a'pO&\u001cGC\u0001\"F!\tA2)\u0003\u0002E3\tyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0003G\u0011\u0001\u0007q)A\nj]\",'/\u001b;fI\u0006#HO]5ckR,7\u000f\u0005\u0002!\u0011&\u0011\u0011j\u0007\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018a\u0003:f]\u0012,'o\u0015;beR$\"a\n'\t\u000b5K\u0001\u0019\u0001(\u0002\u000bM$\u0018M\u001d;\u0011\u0005\u0011z\u0015B\u0001)\r\u0005)1%/Y7f'R\f'\u000f^\u0001\re\u0016tG-\u001a:IK\u0006$WM\u001d\u000b\u0003OMCQ\u0001\u0016\u0006A\u0002U\u000ba\u0001[3bI\u0016\u0014\bC\u0001\u0013W\u0013\t9FBA\u0006Ge\u0006lW\rS3bI\u0016\u0014\bF\u0001\u0001Z!\tQV,D\u0001\\\u0015\taF#\u0001\u0006b]:|G/\u0019;j_:L!AX.\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public final class FrameEventRenderer
extends GraphStage<FlowShape<FrameEvent, ByteString>> {
    private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply("FrameEventRenderer.in");
    private final Outlet<ByteString> out = Outlet$.MODULE$.apply("FrameEventRenderer.out");
    private final FlowShape<FrameEvent, ByteString> shape = new FlowShape(this.in(), this.out());

    public Inlet<FrameEvent> in() {
        return this.in;
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    public FlowShape<FrameEvent, ByteString> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new GraphStageLogic(this){
            private final InHandler Initial;
            private final /* synthetic */ FrameEventRenderer $outer;

            private InHandler Initial() {
                return this.Initial;
            }

            public InHandler akka$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(long initialRemaining, InHandler nextState) {
                return new InHandler(this, initialRemaining, nextState){
                    private long remaining;
                    private final /* synthetic */ $anon$1 $outer;
                    private final InHandler nextState$1;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    private long remaining() {
                        return this.remaining;
                    }

                    private void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.grab(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameData) {
                            FrameData frameData = (FrameData)frameEvent;
                            ByteString data = frameData.data();
                            boolean lastPart = frameData.lastPart();
                            if ((long)data.size() > this.remaining()) {
                                throw new IllegalStateException(new StringBuilder(30).append("Expected ").append(this.remaining()).append(" frame bytes but got ").append(data.size()).toString());
                            }
                            if ((long)data.size() == this.remaining()) {
                                if (!lastPart) {
                                    throw new IllegalStateException("Frame data complete but `lastPart` flag not set");
                                }
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.nextState$1);
                                this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                                return;
                            }
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                            return;
                        }
                        if (frameEvent instanceof FrameStart) {
                            this.$outer.fail(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameStart (need more FrameData first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextState$1 = nextState$1;
                        InHandler.$init$((InHandler)this);
                        this.remaining = initialRemaining$1;
                    }
                };
            }

            public /* synthetic */ FrameEventRenderer akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.Initial = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.grab(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameStart) {
                            FrameStart frameStart = (FrameStart)frameEvent;
                            FrameHeader header = frameStart.header();
                            ByteString data = frameStart.data();
                            Predef$.MODULE$.require(header.length() >= (long)data.size());
                            if (!frameStart.lastPart() && header.length() > 0L) {
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(header.length() - (long)data.length(), this));
                            }
                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().akka$http$impl$engine$ws$FrameEventRenderer$$renderStart(frameStart));
                            return;
                        }
                        if (frameEvent instanceof FrameData) {
                            this.$outer.fail(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        InHandler.$init$((InHandler)this);
                    }
                };
                this.setHandler($outer.in(), this.Initial());
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onPull() {
                        this.$outer.pull(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$((OutHandler)this);
                    }
                });
            }
        };
    }

    public ByteString akka$http$impl$engine$ws$FrameEventRenderer$$renderStart(FrameStart start) {
        return this.renderHeader(start.header()).$plus$plus(start.data());
    }

    private ByteString renderHeader(FrameHeader header) {
        Tuple2.mcII.sp sp2;
        long length = header.length();
        long l = length;
        Tuple2.mcII.sp sp3 = l < 126L ? new Tuple2.mcII.sp((int)l, 0) : (sp2 = l <= 65535L ? new Tuple2.mcII.sp(126, 2) : new Tuple2.mcII.sp(127, 8));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int lengthBits = sp2._1$mcI$sp();
        int extraLengthBytes = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(lengthBits, extraLengthBytes);
        int lengthBits2 = sp4._1$mcI$sp();
        int extraLengthBytes2 = sp4._2$mcI$sp();
        int maskBytes = header.mask().isDefined() ? 4 : 0;
        int totalSize = 2 + extraLengthBytes2 + maskBytes;
        byte[] data = new byte[totalSize];
        int flags = FrameEventRenderer.bool$1(header.fin(), 128) | FrameEventRenderer.bool$1(header.rsv1(), 64) | FrameEventRenderer.bool$1(header.rsv2(), 32) | FrameEventRenderer.bool$1(header.rsv3(), 16);
        data[0] = (byte)(flags | header.opcode().code());
        data[1] = (byte)(FrameEventRenderer.bool$1(header.mask().isDefined(), 128) | lengthBits2);
        int n = extraLengthBytes2;
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                data[2] = (byte)((length & 0xFF00L) >> 8);
                data[3] = (byte)((length & 0xFFL) >> 0);
                break;
            }
            case 8: {
                this.addLongBytes$1(Long.rotateLeft(length, 8), 0, data);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        int maskOffset = 2 + extraLengthBytes2;
        header.mask().foreach((Function1)(JFunction1.mcVI.sp & Serializable)mask -> {
            data$1[maskOffset$1 + 0] = (byte)((mask & 0xFF000000) >> 24);
            data$1[maskOffset$1 + 1] = (byte)((mask & 0xFF0000) >> 16);
            data$1[maskOffset$1 + 2] = (byte)((mask & 0xFF00) >> 8);
            data$1[maskOffset$1 + 3] = (byte)((mask & 0xFF) >> 0);
        });
        return ByteString$.MODULE$.apply(data);
    }

    private static final int bool$1(boolean b, int mask) {
        if (b) {
            return mask;
        }
        return 0;
    }

    private final void addLongBytes$1(long l, int writtenBytes, byte[] data$1) {
        while (writtenBytes < 8) {
            data$1[2 + writtenBytes] = (byte)(l & 0xFFL);
            ++writtenBytes;
            l = Long.rotateLeft(l, 8);
        }
    }
}

