/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnErrorEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnSuccessEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnTimeoutEvent;
import io.github.resilience4j.timelimiter.internal.TimeLimiterImpl;
import io.vavr.collection.Map;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface TimeLimiter {
    public static final String DEFAULT_NAME = "UNDEFINED";

    public static TimeLimiter ofDefaults() {
        return new TimeLimiterImpl(DEFAULT_NAME, TimeLimiterConfig.ofDefaults());
    }

    public static TimeLimiter ofDefaults(String name) {
        return new TimeLimiterImpl(name, TimeLimiterConfig.ofDefaults());
    }

    public static TimeLimiter of(TimeLimiterConfig timeLimiterConfig) {
        return TimeLimiter.of(DEFAULT_NAME, timeLimiterConfig);
    }

    public static TimeLimiter of(String name, TimeLimiterConfig timeLimiterConfig) {
        return new TimeLimiterImpl(name, timeLimiterConfig);
    }

    public static TimeLimiter of(String name, TimeLimiterConfig timeLimiterConfig, Map<String, String> tags) {
        return new TimeLimiterImpl(name, timeLimiterConfig, tags);
    }

    public static TimeLimiter of(Duration timeoutDuration) {
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(timeoutDuration).build();
        return new TimeLimiterImpl(DEFAULT_NAME, timeLimiterConfig);
    }

    public static <T, F extends Future<T>> Callable<T> decorateFutureSupplier(TimeLimiter timeLimiter, Supplier<F> futureSupplier) {
        return timeLimiter.decorateFutureSupplier(futureSupplier);
    }

    public static <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCompletionStage(TimeLimiter timeLimiter, ScheduledExecutorService scheduler, Supplier<F> supplier) {
        return timeLimiter.decorateCompletionStage(scheduler, supplier);
    }

    public String getName();

    public Map<String, String> getTags();

    public TimeLimiterConfig getTimeLimiterConfig();

    default public <T, F extends Future<T>> T executeFutureSupplier(Supplier<F> futureSupplier) throws Exception {
        return TimeLimiter.decorateFutureSupplier(this, futureSupplier).call();
    }

    default public <T, F extends CompletionStage<T>> CompletionStage<T> executeCompletionStage(ScheduledExecutorService scheduler, Supplier<F> supplier) {
        return TimeLimiter.decorateCompletionStage(this, scheduler, supplier).get();
    }

    public <T, F extends Future<T>> Callable<T> decorateFutureSupplier(Supplier<F> var1);

    public <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCompletionStage(ScheduledExecutorService var1, Supplier<F> var2);

    public EventPublisher getEventPublisher();

    public void onSuccess();

    public void onError(Throwable var1);

    public static TimeoutException createdTimeoutExceptionWithName(String name, @Nullable Throwable t) {
        TimeoutException timeoutException = new TimeoutException(String.format("TimeLimiter '%s' recorded a timeout exception.", name));
        if (t != null) {
            timeoutException.setStackTrace(t.getStackTrace());
        }
        return timeoutException;
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<TimeLimiterEvent> {
        public EventPublisher onSuccess(EventConsumer<TimeLimiterOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<TimeLimiterOnErrorEvent> var1);

        public EventPublisher onTimeout(EventConsumer<TimeLimiterOnTimeoutEvent> var1);
    }
}

