/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.journal;

import java.util.Arrays;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.slf4j.Logger;

public class ActiveMQJournalLogger_impl
implements ActiveMQJournalLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJournalLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void runningJournalBlast(Integer numIts) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141000: *** running direct journal blast: {}", (Object)numIts);
        }
    }

    @Override
    public void startingThread() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141002: starting thread for sync speed test");
        }
    }

    @Override
    public void writeRate(Double rate, Long l) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141003: Write rate = {} bytes / sec or {} MiB / sec", (Object)rate, (Object)l);
        }
    }

    @Override
    public void flushRate(Double rate) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141004: Flush rate = {} flushes / sec", (Object)rate);
        }
    }

    @Override
    public void checkFiles() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141005: Check Data Files:");
        }
    }

    @Override
    public void seqOutOfOrder() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141006: Sequence out of order on journal");
        }
    }

    @Override
    public void currentFile(Long fileID, Long id, Long fileFileID, Boolean b) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141007: Current File on the journal is <= the sequence file.getFileID={} on the dataFiles\nCurrentfile.getFileId={} while the file.getFileID()={}\nIs same = ({})", new Object[]{fileID, id, fileFileID, b});
        }
    }

    @Override
    public void fileIdOutOfOrder() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141008: Free File ID out of order");
        }
    }

    @Override
    public void fileTooSmall() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141009: A Free File is less than the maximum data");
        }
    }

    @Override
    public void initializingJdbcDataSource(String dataSourceClassName, String dataSourceProperties) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ141010: Initialising JDBC data source {} with properties {}", (Object)dataSourceClassName, (Object)dataSourceProperties);
        }
    }

    @Override
    public void incompatibleNativeLibrary() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142000: You have a native library with a different version than expected");
        }
    }

    @Override
    public void couldNotGetLock(String fileName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142001: Could not get lock after 60 seconds on closing Asynchronous File: {}", (Object)fileName);
        }
    }

    @Override
    public void fileFinalizedWhileOpen(String fileName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142002: Asynchronous File: {} being finalized with opened state", (Object)fileName);
        }
    }

    @Override
    public void callbackError(String error) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142003: AIO Callback Error: {}", (Object)error);
        }
    }

    @Override
    public void inconsistencyDuringCompacting(Long transactionID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142004: Inconsistency during compacting: CommitRecord ID = {} for an already committed transaction during compacting", (Object)transactionID);
        }
    }

    @Override
    public void inconsistencyDuringCompactingDelete(Long recordID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142005: Inconsistency during compacting: Delete record being read on an existent record (id={})", (Object)recordID);
        }
    }

    @Override
    public void compactingWithNoAddRecord(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142006: Could not find add Record information for record {} during compacting", (Object)id);
        }
    }

    @Override
    public void noRecordDuringCompactReplay(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142007: Can not find record {} during compact replay", (Object)id);
        }
    }

    @Override
    public void couldNotRemoveFile(JournalFile file) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142008: Could not remove file {} from the list of data files", (Object)file);
        }
    }

    @Override
    public void deletingFile(JournalFile file) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142009: *******************************************************************************************************************************\nThe File Storage Attic is full, as the file {}  does not have the configured size, and the file will be removed\n*******************************************************************************************************************************", (Object)file);
        }
    }

    @Override
    public void failedToAddFile(JournalFile nextOpenedFile) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142010: Failed to add file to opened files queue: {}. This should NOT happen!", (Object)nextOpenedFile);
        }
    }

    @Override
    public void compactReadError(JournalFile file) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142011: Error on reading compacting for {}", (Object)file);
        }
    }

    @Override
    public void compactMergeError(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142012: Couldn't find tx={} to merge after compacting", (Object)id);
        }
    }

    @Override
    public void preparedTXIncomplete(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142013: Prepared transaction {} was not considered completed, it will be ignored", (Object)id);
        }
    }

    @Override
    public void txMissingElements(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142014: Transaction {} is missing elements so the transaction is being ignored", (Object)id);
        }
    }

    @Override
    public void uncomittedTxFound(Long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142015: Uncommitted transaction with id {} found and discarded", (Object)id);
        }
    }

    @Override
    public void couldNotStopCompactor() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142016: Could not stop compactor executor after 120 seconds");
        }
    }

    @Override
    public void couldNotStopJournalExecutor() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142017: Could not stop journal executor after 60 seconds");
        }
    }

    @Override
    public void tempFilesLeftOpen() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142018: Temporary files were left unattended after a crash on journal directory, deleting invalid files now");
        }
    }

    @Override
    public void deletingOrphanedFile(String fileToDelete) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142019: Deleting orphaned file {}", (Object)fileToDelete);
        }
    }

    @Override
    public void errorClosingFile(String fileToDelete) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142020: Could not get lock after 60 seconds on closing Asynchronous File: {}", (Object)fileToDelete);
        }
    }

    @Override
    public void errorOnIOCallback(String errorMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142021: Error on IO callback, {}", (Object)errorMessage);
        }
    }

    @Override
    public void timeoutOnPollerShutdown(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142022: Timed out on AIO poller shutdown", (Throwable)e);
        }
    }

    @Override
    public void couldNotCompleteTask(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142023: Executor on file {} couldn't complete its tasks in 60 seconds.", (Object)name, (Object)e);
        }
    }

    @Override
    public void errorCompletingCallback(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142024: Error completing callback", e);
        }
    }

    @Override
    public void errorCallingErrorCallback(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142025: Error calling onError callback", e);
        }
    }

    @Override
    public void timeoutOnWriterShutdown(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142026: Timed out on AIO writer shutdown", e);
        }
    }

    @Override
    public void errorWritingData(String errorMessage, int errorCode, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142027: Error on writing data! {} code - {}", new Object[]{errorMessage, errorCode, e});
        }
    }

    @Override
    public void errorReplayingCommands(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142028: Error replaying pending commands after compacting", e);
        }
    }

    @Override
    public void errorClosingFile(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142029: Error closing file", e);
        }
    }

    @Override
    public void errorOpeningFile(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142030: Could not open a file in 60 Seconds", e);
        }
    }

    @Override
    public void errorRetrievingID(String fileName, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142031: Error retrieving ID part of the file name {}", (Object)fileName, (Object)e);
        }
    }

    @Override
    public void errorReadingFile(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142032: Error reading journal file", e);
        }
    }

    @Override
    public void errorReinitializingFile(JournalFile file, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142033: Error reinitializing file {}", (Object)file, (Object)e);
        }
    }

    @Override
    public void errorSubmittingWrite(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142034: Exception on submitting write", e);
        }
    }

    @Override
    public void couldNotStopJournalAppendExecutor() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ142035: Could not stop journal append executor after 60 seconds");
        }
    }

    @Override
    public void errorDeletingFile(Object e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144000: Failed to delete file {}", e);
        }
    }

    @Override
    public void errorStartingPoller(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144001: Error starting poller", (Throwable)e);
        }
    }

    @Override
    public void errorPushingFile(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144002: Error pushing opened file", (Throwable)e);
        }
    }

    @Override
    public void errorCompacting(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144003: Error compacting", e);
        }
    }

    @Override
    public void errorSchedulingCompacting(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144004: Error scheduling compacting", e);
        }
    }

    @Override
    public void failedToPerfBlast(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144005: Failed to performance blast", e);
        }
    }

    @Override
    public void ioError(int errorCode, String errorMessage) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ144006: IOError code {}, {}", (Object)errorCode, (Object)errorMessage);
        }
    }

    @Override
    public void ignoringShortFile(String fileName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ144007: Ignoring journal file {}: file is shorter then minimum header size. This file is being removed.", (Object)fileName);
        }
    }

    @Override
    public void movingFileToAttic(String fileName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ144008: *******************************************************************************************************************************\nFile {}: was moved under attic, please review it and remove it.\n*******************************************************************************************************************************", (Object)fileName);
        }
    }

    @Override
    public void cantOpenFileTimeout(long timeout) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ144009: Could not get a file in {} seconds, System will retry the open but you may see increased latency in your system", (Object)timeout);
        }
    }

    @Override
    public void criticalIO(String message, Throwable error) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ144010: Critical IO Exception happened: {}", (Object)message, (Object)error);
        }
    }

    @Override
    public void criticalIOFile(String message, String fileName, Throwable error) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ144011: Critical IO Exception happened: {} on {}", new Object[]{message, fileName, error});
        }
    }
}

