/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Stack;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.SystemContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public final class ContextService {
    private static ContextService factory;
    private HeaderPrintWriter errorStream;
    private ThreadLocal<Object> threadContextList = new ThreadLocal();
    private HashSet<ContextManager> allContexts;

    public ContextService() {
        this.errorStream = Monitor.getStream();
        factory = this;
        this.allContexts = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService contextService = factory;
        if (contextService != null) {
            ContextService contextService2 = contextService;
            synchronized (contextService2) {
                contextService.allContexts = null;
                contextService.threadContextList = null;
                factory = null;
            }
        }
    }

    public static ContextService getFactory() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService contextService = factory;
        if (contextService == null) {
            throw new ShutdownException();
        }
        return contextService;
    }

    public static Context getContext(String string) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public static Context getContextOrNull(String string) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ContextService contextService = factory;
        if (contextService == null) {
            return null;
        }
        ContextManager contextManager = contextService.getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public ContextManager getCurrentContextManager() {
        ThreadLocal<Object> threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return null;
        }
        Object object = threadLocal.get();
        if (object instanceof ContextManager) {
            Thread thread = Thread.currentThread();
            ContextManager contextManager = (ContextManager)object;
            if (contextManager.activeThread == thread) {
                return contextManager;
            }
            return null;
        }
        if (object == null) {
            return null;
        }
        return (ContextManager)((ContextManagerStack)object).peek();
    }

    public void resetCurrentContextManager(ContextManager contextManager) {
        ThreadLocal<Object> threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return;
        }
        if (contextManager.activeCount != -1) {
            if (--contextManager.activeCount == 0) {
                contextManager.activeThread = null;
                if (contextManager.isEmpty()) {
                    threadLocal.set(null);
                }
            }
            return;
        }
        ContextManagerStack contextManagerStack = (ContextManagerStack)threadLocal.get();
        contextManagerStack.pop();
        ContextManager contextManager2 = (ContextManager)contextManagerStack.peek();
        boolean bl = false;
        boolean bl2 = false;
        for (ContextManager contextManager3 : contextManagerStack) {
            if (contextManager3 != contextManager2) {
                bl = true;
            }
            if (contextManager3 != contextManager) continue;
            bl2 = true;
        }
        if (!bl2) {
            contextManager.activeThread = null;
            contextManager.activeCount = 0;
        }
        if (!bl) {
            contextManager2.activeCount = contextManagerStack.size();
            threadLocal.set(contextManager2);
        }
    }

    private boolean addToThreadList(Thread thread, ContextManager contextManager) {
        ContextManagerStack contextManagerStack;
        ThreadLocal<Object> threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return false;
        }
        Object object = threadLocal.get();
        if (contextManager == object) {
            return true;
        }
        if (object == null) {
            threadLocal.set(contextManager);
            return true;
        }
        if (object instanceof ContextManager) {
            ContextManager contextManager2 = (ContextManager)object;
            if (thread == null) {
                thread = Thread.currentThread();
            }
            if (contextManager2.activeThread != thread) {
                threadLocal.set(contextManager);
                return true;
            }
            contextManagerStack = new ContextManagerStack();
            threadLocal.set(contextManagerStack);
            for (int i = 0; i < contextManager2.activeCount; ++i) {
                contextManagerStack.push(contextManager2);
            }
            contextManager2.activeCount = -1;
        } else {
            contextManagerStack = (ContextManagerStack)object;
        }
        contextManagerStack.push(contextManager);
        contextManager.activeCount = -1;
        return false;
    }

    public void setCurrentContextManager(ContextManager contextManager) {
        Thread thread = null;
        if (contextManager.activeThread == null) {
            contextManager.activeThread = thread = Thread.currentThread();
        }
        if (this.addToThreadList(thread, contextManager)) {
            ++contextManager.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager newContextManager() {
        ContextManager contextManager = new ContextManager(this, this.errorStream);
        new SystemContext(contextManager);
        ContextService contextService = this;
        synchronized (contextService) {
            this.allContexts.add(contextManager);
        }
        return contextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllActiveThreads(Context context) {
        Thread thread = Thread.currentThread();
        ContextService contextService = this;
        synchronized (contextService) {
            for (ContextManager contextManager : this.allContexts) {
                Thread thread2 = contextManager.activeThread;
                if (thread2 == thread || thread2 == null) continue;
                final Thread thread3 = thread2;
                if (!contextManager.setInterrupted(context)) continue;
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            thread3.interrupt();
                            return null;
                        }
                    });
                }
                catch (AccessControlException accessControlException) {}
            }
        }
    }

    synchronized void removeContext(ContextManager contextManager) {
        if (this.allContexts != null) {
            this.allContexts.remove(contextManager);
        }
    }

    private static class ContextManagerStack
    extends Stack<ContextManager> {
        private ContextManagerStack() {
        }
    }
}

