/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

public class ByteArrayWindow {
    private byte[] value;
    private int offset;
    private int length;

    public ByteArrayWindow(byte[] byArray, int n, int n2) {
        this.value = byArray;
        this.offset = n;
        this.length = n2;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public int getOffset() {
        return this.offset;
    }

    public void set(int n, byte by) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException("" + n + " >= " + this.length);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("" + n);
        }
        this.value[n + this.offset] = by;
    }

    public byte get(int n) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException("" + n + " >= " + this.length);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("" + n);
        }
        return this.value[n + this.offset];
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object object) {
        if (object instanceof ByteArrayWindow) {
            ByteArrayWindow byteArrayWindow = (ByteArrayWindow)object;
            if (byteArrayWindow.length != this.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (byteArrayWindow.value[i] == this.value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(ByteArrayWindow byteArrayWindow, int n) {
        if (byteArrayWindow.length < n || this.length < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.value[this.offset + i] == byteArrayWindow.value[byteArrayWindow.offset + i]) continue;
            return false;
        }
        return true;
    }
}

