/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LEDataOutputStream
extends DecoratingOutputStream
implements DataOutput {
    private final byte[] buf = new byte[8];
    protected long written;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LEDataOutputStream(@WillCloseWhenClosed OutputStream out) {
        super(out);
    }

    private void inc(int inc) {
        long temp = this.written + (long)inc;
        this.written = temp >= 0L ? temp : Long.MAX_VALUE;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.inc(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.inc(len);
    }

    @Override
    public final void writeBoolean(boolean b) throws IOException {
        this.delegate.write(b ? 1 : 0);
        this.inc(1);
    }

    @Override
    public final void writeByte(int b) throws IOException {
        this.delegate.write(b);
        this.inc(1);
    }

    @Override
    public final void writeChar(int c) throws IOException {
        this.writeShort(c);
    }

    @Override
    public final void writeShort(int s) throws IOException {
        this.buf[0] = (byte)s;
        this.buf[1] = (byte)(s >>= 8);
        this.delegate.write(this.buf, 0, 2);
        this.inc(2);
    }

    @Override
    public final void writeInt(int i) throws IOException {
        this.buf[0] = (byte)i;
        this.buf[1] = (byte)(i >>= 8);
        this.buf[2] = (byte)(i >>= 8);
        this.buf[3] = (byte)(i >>= 8);
        this.delegate.write(this.buf, 0, 4);
        this.inc(4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.buf[0] = (byte)l;
        this.buf[1] = (byte)(l >>= 8);
        this.buf[2] = (byte)(l >>= 8);
        this.buf[3] = (byte)(l >>= 8);
        this.buf[4] = (byte)(l >>= 8);
        this.buf[5] = (byte)(l >>= 8);
        this.buf[6] = (byte)(l >>= 8);
        this.buf[7] = (byte)(l >>= 8);
        this.delegate.write(this.buf, 0, 8);
        this.inc(8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeShort(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long size() {
        return this.written;
    }
}

