/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.dto.NewRulesFileDTO;
import com.xebialabs.deployit.core.rest.exception.NewRulesFileException;
import com.xebialabs.deployit.core.rest.exception.StitchException;
import com.xebialabs.deployit.core.rest.exception.StitchException$;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.RulesFileService;
import com.xebialabs.deployit.plugin.stitch.service.RulesFileService$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.ExecutionLogger;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.adapter.FolderSourceEntryAdapter$;
import com.xebialabs.deployit.repository.RepositoryService;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.eclipse.jgit.api.Git;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0007\u000f\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003C\u0001\u0011\u00053\tC\u0003U\u0001\u0011\u0005S\u000bC\u0003U\u0001\u0011\u0005#\rC\u0003~\u0001\u0011\u0005c\u0010\u0003\u0004~\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\u0006\u0001\t\u0013\tIB\u0001\u000bSk2,7OR5mKN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u001fA\tqa]3sm&\u001cWM\u0003\u0002\u0012%\u000511\u000f^5uG\"T!a\u0005\u000b\u0002\rAdWoZ5o\u0015\t)b#\u0001\u0005eKBdw._5u\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012%\u001b\u0005q\u0011BA\u0013\u000f\u0005A\u0011V\u000f\\3t\r&dWmU3sm&\u001cW-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002-S\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002\u001b\u001dLGo\u00149t'\u0016\u0014h/[2f!\t\u0019s&\u0003\u00021\u001d\tiq)\u001b;PaN\u001cVM\u001d<jG\u0016\f\u0011C]3q_NLGo\u001c:z\u0007J\fw\u000f\\3s!\t\u0019$(D\u00015\u0015\t)d'A\u0004de\u0006<H.\u001a:\u000b\u0005]B\u0014!B5oI\u0016D(BA\u001d\u000f\u0003\u0019)gnZ5oK&\u00111\b\u000e\u0002\u0012%\u0016\u0004xn]5u_JL8I]1xY\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005CA\u0012\u0001\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u0011\u0015\tD\u00011\u00013\u0003q1\u0018\r\\5eCR,g)\u001b7f\u001d\u0006l\u0017N\\4D_:4XM\u001c;j_:$\"\u0001R$\u0011\u0005u)\u0015B\u0001$\u001f\u0005\u0011)f.\u001b;\t\u000b!+\u0001\u0019A%\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004\"AS)\u000f\u0005-{\u0005C\u0001'\u001f\u001b\u0005i%B\u0001(\u001b\u0003\u0019a$o\\8u}%\u0011\u0001KH\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q=\u000512\r[3dW\u0012+\b\u000f\\5dCR,g)\u001b7f\u001d\u0006lW\r\u0006\u0002E-\")qK\u0002a\u00011\u0006ya.Z<Sk2,7OR5mK\u0012#v\n\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006\u0019A\r^8\u000b\u0005us\u0016\u0001\u0002:fgRT!a\u0018\u000b\u0002\t\r|'/Z\u0005\u0003Cj\u0013qBT3x%VdWm\u001d$jY\u0016$Ek\u0014\u000b\u0004\t\u000e$\u0007\"B,\b\u0001\u0004A\u0006\"B3\b\u0001\u00041\u0017AC2m_:,GMU3q_B)QdZ5v\u0013&\u0011\u0001N\b\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005)\u001cX\"A6\u000b\u00051l\u0017aA1qS*\u0011an\\\u0001\u0005U\u001eLGO\u0003\u0002qc\u00069Qm\u00197jaN,'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uW\n\u0019q)\u001b;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018AA5p\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\t\u0019KG.Z\u0001\u0017m\u0006d\u0017\u000eZ1uKN{WO]2f/&$\bNU;mKR\u0011Ai \u0005\u0006/\"\u0001\r\u0001\u0017\u000b\u0006\t\u0006\r\u0011Q\u0001\u0005\u0006/&\u0001\r\u0001\u0017\u0005\u0006K&\u0001\rAZ\u0001\u0016S:\u001cXM\u001d;GS2,Gk\u001c'pG\u0006d'+\u001a9p)\u0015!\u00151BA\u0007\u0011\u00159&\u00021\u0001Y\u0011\u0019\tyA\u0003a\u0001k\u0006aAn\\2bYJ+\u0007o\u001c#je\u00061\u0002O]3qCJ,Gj\\2bYJ+\u0007o\\:ji>\u0014\u0018\u0010F\u0002g\u0003+AQaV\u0006A\u0002a\u000b!c\u00195fG.$\u0015N]3di>\u0014\u0018\u0010\u0016:fKR9A)a\u0007\u0002 \u0005\r\u0002BBA\u000f\u0019\u0001\u0007Q/A\u0002eSJDa!!\t\r\u0001\u0004I\u0015!\u00044jY\u0016$\u0015N]3di>\u0014\u0018\u0010C\u0003I\u0019\u0001\u0007\u0011\nK\u0002\u0001\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T1!!\rr\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017\u0002BA\u001b\u0003W\u0011qaU3sm&\u001cW\rK\u0002\u0001\u0003s\u0001B!a\u000f\u0002J5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0006b]:|G/\u0019;j_:TA!a\u0011\u0002F\u00059a-Y2u_JL(\u0002BA$\u0003_\tQAY3b]NLA!a\u0013\u0002>\tI\u0011)\u001e;po&\u0014X\r\u001a")
public class RulesFileServiceImpl
implements RulesFileService {
    private final RepositoryService repositoryService;
    private final GitOpsService gitOpsService;
    private final RepositoryCrawler repositoryCrawler;

    @Override
    public void validateFileNamingConvention(String fileName) {
        if (!RepositoryCrawler$.MODULE$.stitchDeclarationFilePrefixes().exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)fileName.startsWith(prefix))) || !RepositoryCrawler$.MODULE$.stitchDeclarationFileSuffixes().exists((Function1 & Serializable)suffix -> BoxesRunTime.boxToBoolean((boolean)fileName.endsWith(suffix)))) {
            throw new NewRulesFileException("File name does not follow the naming convention");
        }
    }

    @Override
    public void checkDuplicateFileName(NewRulesFileDTO newRulesFileDTO) {
        Tuple3<Git, File, String> clonedGitRepository = this.prepareLocalRepository(newRulesFileDTO);
        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkDuplicateFileName(newRulesFileDTO, clonedGitRepository));
        this.gitOpsService.clean((Git)clonedGitRepository._1(), (File)clonedGitRepository._2());
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
    }

    @Override
    public void checkDuplicateFileName(NewRulesFileDTO newRulesFileDTO, Tuple3<Git, File, String> clonedRepo) {
        if (newRulesFileDTO.directory().isEmpty()) {
            if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])((File)clonedRepo._2()).listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile()))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RulesFileServiceImpl.$anonfun$checkDuplicateFileName$3(newRulesFileDTO, x$2)))) {
                throw new NewRulesFileException("File name is already taken in root directory.");
            }
            return;
        }
        this.checkDirectoryTree((File)clonedRepo._2(), newRulesFileDTO.directory(), newRulesFileDTO.fileName());
    }

    @Override
    public void validateSourceWithRule(NewRulesFileDTO newRulesFileDTO) {
        Tuple3<Git, File, String> localRepo = this.prepareLocalRepository(newRulesFileDTO);
        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateSourceWithRule(newRulesFileDTO, localRepo));
        this.gitOpsService.clean((Git)localRepo._1(), (File)localRepo._2());
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
    }

    @Override
    public void validateSourceWithRule(NewRulesFileDTO newRulesFileDTO, Tuple3<Git, File, String> clonedRepo) {
        Tuple3<Git, File, String> tuple3 = clonedRepo;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        File localRepoDir = (File)tuple3._2();
        File localRepoDir2 = localRepoDir;
        this.insertFileToLocalRepo(newRulesFileDTO, localRepoDir2);
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.repositoryCrawler.crawl(FolderSourceEntryAdapter$.MODULE$.apply(localRepoDir2.toPath()), new ExecutionLogger()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (exception instanceof RepositoryCrawler.StitchRepositoryException) {
                RepositoryCrawler.StitchRepositoryException stitchRepositoryException = (RepositoryCrawler.StitchRepositoryException)((Object)exception);
                throw new StitchException("", (Throwable)((Object)stitchRepositoryException));
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
    }

    private void insertFileToLocalRepo(NewRulesFileDTO newRulesFileDTO, File localRepoDir) {
        String repoPath = localRepoDir.getAbsolutePath();
        String directory = newRulesFileDTO.directory();
        String fileName = newRulesFileDTO.fileName();
        Path fullFilePath = Path.of(repoPath, directory, fileName);
        Using$.MODULE$.apply((Function0 & Serializable)() -> new PrintWriter(new FileWriter(fullFilePath.toFile(), false)), (Function1 & Serializable)writer -> {
            writer.write(newRulesFileDTO.content());
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse((Function0 & Serializable)() -> {
            throw new StitchException("Could not write to file " + fullFilePath.toAbsolutePath(), StitchException$.MODULE$.apply$default$2());
        });
    }

    private Tuple3<Git, File, String> prepareLocalRepository(NewRulesFileDTO newRulesFileDTO) {
        return RulesFileService$.MODULE$.prepareLocalRepository(newRulesFileDTO, this.repositoryService, this.gitOpsService);
    }

    private void checkDirectoryTree(File dir, String fileDirectory, String fileName) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)file -> {
            RulesFileServiceImpl.$anonfun$checkDirectoryTree$1(this, fileDirectory, fileName, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicateFileName$3(NewRulesFileDTO newRulesFileDTO$2, File x$2) {
        return x$2.getAbsolutePath().endsWith(newRulesFileDTO$2.fileName());
    }

    public static final /* synthetic */ void $anonfun$checkDirectoryTree$1(RulesFileServiceImpl $this, String fileDirectory$1, String fileName$2, File file) {
        if (file.isFile()) {
            if (file.getAbsolutePath().replace("\\", "/").endsWith(fileDirectory$1 + "/" + fileName$2)) {
                throw new NewRulesFileException("File name is already taken in selected directory [" + fileDirectory$1 + "]");
            }
            return;
        }
        $this.checkDirectoryTree(file, fileDirectory$1, fileName$2);
    }

    public RulesFileServiceImpl(RepositoryService repositoryService, GitOpsService gitOpsService, RepositoryCrawler repositoryCrawler) {
        this.repositoryService = repositoryService;
        this.gitOpsService = gitOpsService;
        this.repositoryCrawler = repositoryCrawler;
    }
}

