/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.scattered.BiasManager;
import org.infinispan.scattered.ScatteredStateProvider;
import org.infinispan.util.ByteString;

public class ScatteredStateConfirmRevokedCommand
extends AbstractStateTransferCommand {
    public static final byte COMMAND_ID = 115;

    public ScatteredStateConfirmRevokedCommand() {
        this(null);
    }

    public ScatteredStateConfirmRevokedCommand(ByteString cacheName) {
        super((byte)115, cacheName);
    }

    public ScatteredStateConfirmRevokedCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super((byte)115, cacheName, topologyId, segments);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        ScatteredStateProvider stateProvider = (ScatteredStateProvider)registry.getStateTransferManager().getStateProvider();
        BiasManager biasManager = registry.getBiasManager().running();
        return stateProvider.confirmRevokedSegments(this.topologyId).thenApply(nil -> {
            if (biasManager != null) {
                biasManager.revokeLocalBiasForSegments(this.segments);
            }
            return null;
        });
    }

    @Override
    public String toString() {
        return "ScatteredStateConfirmRevokedCommand{topologyId=" + this.topologyId + ", segments=" + this.segments + ", cacheName=" + this.cacheName + "}";
    }
}

