/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadCommittedEntry<K, V>
implements MVCCEntry<K, V> {
    private static final Log log = LogFactory.getLog(ReadCommittedEntry.class);
    protected K key;
    protected V value;
    protected long created = -1L;
    protected long lastUsed = -1L;
    protected short flags = 0;
    protected Metadata metadata;
    protected PrivateMetadata internalMetadata;
    protected V oldValue;
    protected Metadata oldMetadata;

    public ReadCommittedEntry(K key, V value, Metadata metadata) {
        this.key = key;
        this.value = value;
        this.metadata = metadata;
        this.oldValue = value;
        this.oldMetadata = metadata;
    }

    final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (short)(this.flags | flag.mask);
    }

    private void unsetFlag(Flags flag) {
        this.flags = (short)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return this.metadata == null ? -1L : this.metadata.lifespan();
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata == null ? -1L : this.metadata.maxIdle();
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public final boolean isNull() {
        return this.value == null;
    }

    @Override
    public void commit(DataContainer<K, V> container) {
        if (this.shouldCommit()) {
            if (this.isEvicted()) {
                container.evict(this.key);
            } else if (this.isRemoved()) {
                container.remove(this.key);
            } else if (this.value != null) {
                container.put(this.key, this.value, this.metadata);
            }
        }
    }

    public CompletionStage<Void> commit(int segment, InternalDataContainer<K, V> container) {
        if (segment < 0) {
            throw new IllegalArgumentException("Segment must be 0 or greater");
        }
        if (this.shouldCommit()) {
            this.setCommitted();
            if (this.isEvicted()) {
                return container.evict(segment, this.key);
            }
            if (this.isRemoved()) {
                container.remove(segment, this.key);
            } else if (this.value != null) {
                container.put(segment, this.key, this.value, this.metadata, this.internalMetadata, this.created, this.lastUsed);
            }
        }
        return CompletableFutures.completedNull();
    }

    private boolean shouldCommit() {
        if (this.isChanged()) {
            if (log.isTraceEnabled()) {
                log.tracef("Updating entry (key=%s removed=%s changed=%s created=%s committed=%s value=%s metadata=%s internalMetadata=%s)", new Object[]{Util.toStr(this.getKey()), this.isRemoved(), this.isChanged(), this.isCreated(), this.isCommitted(), Util.toStr(this.value), this.getMetadata(), this.internalMetadata});
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    @Override
    public final void setChanged(boolean changed) {
        this.setFlag(changed, Flags.CHANGED);
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
    }

    @Override
    public boolean skipLookup() {
        return false;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public V setValue(V value) {
        V prev = this.value;
        this.value = value;
        return prev;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public final boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        this.setFlag(created, Flags.CREATED);
    }

    @Override
    public boolean isRemoved() {
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public boolean isExpired() {
        return this.isFlagSet(Flags.EXPIRED);
    }

    @Override
    public void setCommitted() {
        this.setFlag(Flags.COMMITTED);
    }

    @Override
    public boolean isCommitted() {
        return this.isFlagSet(Flags.COMMITTED);
    }

    @Override
    public boolean isLoaded() {
        return this.isFlagSet(Flags.LOADED);
    }

    @Override
    public boolean isSkipSharedStore() {
        return this.isFlagSet(Flags.SKIP_SHARED_STORE);
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.setFlag(loaded, Flags.LOADED);
    }

    @Override
    public void resetCurrentValue() {
        this.value = this.oldValue;
        this.metadata = this.oldMetadata;
    }

    @Override
    public final void updatePreviousValue() {
        this.oldValue = this.value;
        this.oldMetadata = this.metadata;
    }

    @Override
    public final V getOldValue() {
        return this.oldValue;
    }

    @Override
    public final Metadata getOldMetadata() {
        return this.oldMetadata;
    }

    @Override
    public final void setRemoved(boolean removed) {
        this.setFlag(removed, Flags.REMOVED);
    }

    @Override
    public void setEvicted(boolean evicted) {
        this.setFlag(evicted, Flags.EVICTED);
    }

    @Override
    public void setExpired(boolean expired) {
        this.setFlag(expired, Flags.EXPIRED);
    }

    @Override
    public void setSkipSharedStore() {
        this.setFlag(true, Flags.SKIP_SHARED_STORE);
    }

    final void setFlag(boolean enable, Flags flag) {
        if (enable) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    @Override
    public ReadCommittedEntry<K, V> clone() {
        try {
            return (ReadCommittedEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setCreated(long created) {
        this.created = created;
    }

    @Override
    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata metadata) {
        this.internalMetadata = metadata;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode((Object)this) + "){key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", oldValue=" + Util.toStr(this.oldValue) + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isExpired=" + this.isExpired() + ", isCommited=" + this.isCommitted() + ", skipLookup=" + this.skipLookup() + ", metadata=" + this.metadata + ", oldMetadata=" + this.oldMetadata + ", internalMetadata=" + this.internalMetadata + "}";
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        COMMITTED(8),
        EVICTED(16),
        EXPIRED(32),
        SKIP_LOOKUP(64),
        READ(128),
        LOADED(256),
        SKIP_SHARED_STORE(512);

        final short mask;

        private Flags(int mask) {
            this.mask = (short)mask;
        }
    }
}

