/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.exec.spi.ExecutionContext;

public class InPredicateRestrictionProducer
implements MatchingIdRestrictionProducer {
    @Override
    public InListPredicate produceRestriction(List<?> matchingIdValues, EntityMappingType entityDescriptor, int valueIndex, ModelPart valueModelPart, TableReference mutatingTableReference, Supplier<Consumer<SelectableConsumer>> columnsToMatchVisitationSupplier, ExecutionContext executionContext) {
        InListPredicate predicate;
        assert (matchingIdValues != null);
        assert (!matchingIdValues.isEmpty());
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        int idColumnCount = identifierMapping.getJdbcTypeCount();
        assert (idColumnCount > 0);
        if (idColumnCount == 1) {
            BasicValuedModelPart basicIdMapping = (BasicValuedModelPart)((Object)identifierMapping);
            String idColumn = basicIdMapping.getSelectionExpression();
            ColumnReference inFixture = new ColumnReference(mutatingTableReference, idColumn, false, null, basicIdMapping.getJdbcMapping());
            predicate = new InListPredicate(inFixture);
            matchingIdValues.forEach(matchingId -> predicate.addExpression(new JdbcLiteral<Object>(matchingId, basicIdMapping.getJdbcMapping())));
        } else {
            ArrayList columnReferences = new ArrayList(idColumnCount);
            ArrayList jdbcMappings = new ArrayList(idColumnCount);
            identifierMapping.forEachSelectable((columnIndex, selection) -> {
                columnReferences.add(new ColumnReference(mutatingTableReference, selection));
                jdbcMappings.add(selection.getJdbcMapping());
            });
            SqlTuple inFixture = new SqlTuple(columnReferences, identifierMapping);
            predicate = new InListPredicate(inFixture);
            matchingIdValues.forEach(matchingId -> {
                assert (matchingId instanceof Object[]);
                Object[] matchingIdParts = (Object[])matchingId;
                ArrayList<JdbcLiteral<Object>> tupleParts = new ArrayList<JdbcLiteral<Object>>(idColumnCount);
                for (int p = 0; p < matchingIdParts.length; ++p) {
                    tupleParts.add(new JdbcLiteral<Object>(matchingIdParts[p], (JdbcMapping)jdbcMappings.get(p)));
                }
                predicate.addExpression(new SqlTuple(tupleParts, identifierMapping));
            });
        }
        return predicate;
    }
}

