/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpOpenSshdConnection
extends SshSftpConnection {
    private static Logger logger = LoggerFactory.getLogger(SshSftpOpenSshdConnection.class);

    public SshSftpOpenSshdConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        OverthereUtils.checkArgument(this.os == OperatingSystemFamily.WINDOWS, "Cannot create a %s connection to a host that is not running Windows", this.protocolAndConnectionType);
    }

    @Override
    protected void connect() {
        super.connect();
    }

    @Override
    protected String pathToSftpPath(String path) {
        if (path.length() < 2 || path.charAt(1) != ':') {
            throw new RuntimeIOException(String.format("Cannot translate Windows path [%s] to a OpenSSHD path because it is not a Windows path", path));
        }
        char driveLetter = Character.toUpperCase(path.charAt(0));
        String pathInDrive = path.substring(2).replace('\\', '/');
        String translatedPath = "/" + driveLetter + ":" + pathInDrive;
        logger.trace("Translated Windows path [{}] to OpenSSHD path [{}]", (Object)path, (Object)translatedPath);
        return translatedPath;
    }
}

