/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintHelper {
    public static final String INDENT = "    ";
    private final Set<String> repositoryObjectParentIds = Sets.newHashSet();

    private PrintHelper() {
    }

    public static PrintHelper getInstance() {
        return new PrintHelper();
    }

    public void printCi(ConfigurationItem object, RepositoryService repository) {
        this.printTopLevelCiWithIndent(object, "", repository);
    }

    public void printCis(Collection<ConfigurationItem> cis, RepositoryService repository) {
        this.repositoryObjectParentIds.addAll(Collections2.transform(cis, ConfigurationItem::getId));
        for (ConfigurationItem ci : cis) {
            this.printTopLevelCiWithIndent(ci, "", repository);
        }
    }

    private void printTopLevelCiWithIndent(ConfigurationItem object, String indent, RepositoryService repository) {
        ConfigurationItem toPrint = object;
        if (object instanceof ValidatedConfigurationItem) {
            toPrint = ((ValidatedConfigurationItem)object).getWrapped();
        }
        System.out.println(toPrint.getType());
        this.printCiProperties(toPrint, indent, repository);
    }

    private void printCiProperties(ConfigurationItem object, String indent, RepositoryService repository) {
        this.repositoryObjectParentIds.add(object.getId());
        PrintHelper.println(indent, "id", object.getId(), false);
        PrintHelper.println(indent, "values", null, true);
        this.printValidationMessages(object, indent);
        this.printValues(object, indent + INDENT, repository);
    }

    private void printValidationMessages(ConfigurationItem object, String indent) {
        List msgs = object.get$validationMessages();
        if (!msgs.isEmpty()) {
            PrintHelper.println(indent, "validation-messages", null, false);
            Iterator iterator = msgs.iterator();
            while (iterator.hasNext()) {
                ValidationMessage msg = (ValidationMessage)iterator.next();
                PrintHelper.println(indent + "|   ", msg.getPropertyName(), msg.getMessage(), !iterator.hasNext());
            }
        }
    }

    private void printValues(ConfigurationItem object, String indent, RepositoryService repository) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)object.getType());
        Iterator iterator = descriptor.getPropertyDescriptors().iterator();
        block8: while (iterator.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)iterator.next();
            Object value = pd.get(object);
            if (value == null) continue;
            boolean last = !iterator.hasNext();
            String deepIndent = indent + (iterator.hasNext() ? "|   " : INDENT);
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    PrintHelper.println(indent, pd, value.toString(), last);
                    break;
                }
                case DATE: {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((Date)value);
                    PrintHelper.println(indent, pd, DatatypeConverter.printDateTime((Calendar)cal), last);
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    PrintHelper.println(indent, pd, null, last);
                    Collection strings = (Collection)value;
                    Iterator stringIt = strings.iterator();
                    while (stringIt.hasNext()) {
                        String string = (String)stringIt.next();
                        PrintHelper.println(deepIndent, string, null, !stringIt.hasNext());
                    }
                    continue block8;
                }
                case MAP_STRING_STRING: {
                    PrintHelper.println(indent, pd, null, last);
                    Map stringMap = (Map)value;
                    for (Map.Entry mapEntry : stringMap.entrySet()) {
                        PrintHelper.println(deepIndent, (String)mapEntry.getKey(), (String)mapEntry.getValue(), !iterator.hasNext());
                    }
                    continue block8;
                }
                case CI: {
                    String id = (String)value;
                    if (!this.repositoryObjectParentIds.contains(id)) {
                        ConfigurationItem nested = repository.read(id);
                        PrintHelper.println(indent, pd, nested.getType().toString(), last);
                        this.printCiProperties(nested, deepIndent, repository);
                        break;
                    }
                    PrintHelper.println(indent, pd, "REFERENCE => " + id, last);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    PrintHelper.println(indent, pd, null, last);
                    Collection ids = (Collection)value;
                    this.printSetOfCis(deepIndent, ids, repository);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown PropertyKind: " + pd.getKind() + " for " + pd.getFqn());
                }
            }
        }
    }

    private void printSetOfCis(String indent, Collection<String> ids, RepositoryService repository) {
        Iterator<String> idIt = ids.iterator();
        while (idIt.hasNext()) {
            String nestedid = idIt.next();
            if (!this.repositoryObjectParentIds.contains(nestedid)) {
                ConfigurationItem nestedCi = repository.read(nestedid);
                PrintHelper.println(indent, nestedCi.getType().toString(), null, !idIt.hasNext());
                this.printCiProperties(nestedCi, indent + (idIt.hasNext() ? "|   " : INDENT), repository);
                continue;
            }
            PrintHelper.println(indent, "REFERENCE => " + nestedid, null, !idIt.hasNext());
        }
    }

    private static String getIndicator(PropertyDescriptor pd) {
        if (pd.isHidden()) {
            return " (hidden)";
        }
        return "";
    }

    private static void println(String indent, String key, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + key + (String)(value != null ? ": " + value : ""));
    }

    private static void println(String indent, PropertyDescriptor pd, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + pd.getName() + (String)(value != null ? ": " + value : "") + PrintHelper.getIndicator(pd));
    }
}

