/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class LicenseTransaction {
    private static final Function<Type, AtomicInteger> COMPUTE_FUNCTION = t -> new AtomicInteger(0);
    private Map<Type, AtomicInteger> ciCountByType = new HashMap<Type, AtomicInteger>();

    public void registerCreate(Type t, int n) {
        this.ciCountByType.computeIfAbsent(t, COMPUTE_FUNCTION).addAndGet(n);
    }

    public void registerDelete(Type t, int n) {
        this.ciCountByType.computeIfAbsent(t, COMPUTE_FUNCTION).addAndGet(-n);
    }

    public Set<Type> getCiCountTypes() {
        return this.ciCountByType.keySet();
    }

    public int getCiCount(Type type) {
        return this.ciCountByType.computeIfAbsent(type, COMPUTE_FUNCTION).get();
    }
}

