package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.db.MainDatabase
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader
import com.xebialabs.deployit.util.PasswordEncrypter

class MainRepositoryConfigurationUpgrader extends DeployConfUpgrader {

  override def configurationFileDescription: String = "Main repository"

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.repository")) {

      def transformFn(config: MainDatabase): MainDatabase = {
        val dbPasswordKey = "xl.repository.database.db-password"
        val password: String = if (confFile.hasPath(dbPasswordKey))
          PasswordEncrypter.getInstance().ensureDecrypted(confFile.getString(dbPasswordKey))
        else
          null
        config.database.setDbPassword(password)
        config
      }

      createYamlConfiguration(confFile, "xl.repository", "xl.repository", classOf[MainDatabase], transformFn)
      encryptCentralConfigurationProperties()
    }
  }

  override def destinationFileName: String = "deploy-repository.yaml"
}
