package com.xebialabs.deployit.core.upgrade.configuration

import com.xebialabs.deployit.core.upgrade.configuration.common.BaseConfigurationUpgrader
import com.xebialabs.deployit.server.api.upgrade.Version

import scala.util.{Failure, Success, Try}

/*
Configuration Upgrader for 10.3 for remove unused satellite property
*/
class Deploy1030SatelliteConfigurationUpgrader extends BaseConfigurationUpgrader {

  override def destinationFileName: String = "deploy-satellite.yaml"

  override def configurationFileDescription: String = "Satellite config"

  override def upgradeVersion(): Version = Version.valueOf("central-config", "10.3.0")

  override def doUpgrade(): Boolean = Try {
    updateConfiguration()
  } match {
    case Success(_) =>
      logger.debug(s"Removed 'deploy.satellite.timeout.info' from $destinationFileName")
      true
    case Failure(exception: Exception) =>
      logger.debug(s"$destinationFileName configuration cannot be updated: " + exception.getMessage)
      false
    case _ =>
      false
  }

  override protected def updateConfiguration(): Unit = {
    deleteCentralConfigurationProperties(Seq("deploy.satellite.timeout.info"))
  }
}

