package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.SatelliteProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class SatelliteConfigurationUpgrader extends DeployConfUpgrader {

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.satellite")) {
      createYamlConfiguration(confFile, "xl.satellite", "deploy.satellite", classOf[SatelliteProperties])
    }
  }

  override def configurationFileDescription: String = "Satellite Configuration"

  override def destinationFileName: String = "deploy-satellite.yaml"

}
