package com.xebialabs.deployit.core.upgrade.configuration

import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class RemoveJcrMigrationConfigurationUpgrader extends DeployConfUpgrader {

  override def configurationFileDescription: String = "Migration tokens"

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.migration")) {
      excludeXlDeployConfSections(List("xl.migration"))
      info(s"Section xl.migration is removed from xl-deploy.conf")
    }
  }

  override def destinationFileName: String = ""
}
