package com.xebialabs.deployit.core.upgrade.configuration.common

import java.io.File
import java.nio.file.{Files, StandardCopyOption}

trait MoveFileConfigurationUpgrader extends BaseConfigurationUpgrader {

  override protected def updateConfiguration(): Unit = {
    val sourceFile: File = new File(s"$confFolder/$originalFileName")
    info(s"Source file location is: $sourceFile")
    if (sourceFile.exists()) {
      info(s"Destination file location is: $destinationFile")
      Files.move(sourceFile.toPath, destinationFile.toPath, StandardCopyOption.REPLACE_EXISTING)
    }
  }

  def originalFileName: String
}
