package com.xebialabs.deployit.core.upgrade.configuration.common

import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator.Feature
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import com.typesafe.config.Config
import com.xebialabs.xlplatform.config.ConfigLoader
import org.yaml.snakeyaml.{DumperOptions, Yaml}

import java.io.{File, FileInputStream, StringWriter}
import java.nio.file.Files
import java.util

object ConfigUtils {

  def readYamlFile(file: File): util.Map[String, AnyRef] = {
    val options = new DumperOptions()
    options.setPrettyFlow(true)
    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)
    val parser = new Yaml(options)
    parser.load(Files.readString(file.toPath))
  }

  def configAsMap[T](config: T): util.Map[String, AnyRef] = {
    val mapper = new ObjectMapper(new YAMLFactory().disable(Feature.WRITE_DOC_START_MARKER))
    val writer = new StringWriter()
    mapper.registerModule(DefaultScalaModule)

    mapper.setSerializationInclusion(Include.NON_ABSENT)
    mapper.writeValue(writer, config)
    val parser = new Yaml()
    parser.load(writer.toString)
  }

  def getValue(file: File, keyPath: List[String]): AnyRef = {
    if (file.exists()) {
      try {
        val map = readYamlFile(file)
        val v = keyPath.dropRight(1).foldLeft(map) { (acc, key) =>
          acc.get(key).asInstanceOf[util.Map[String, AnyRef]]
        }
        val value = v.get(keyPath.lastOption.getOrElse(""))
        if (value != null) {
          return Some(value)
        }
      }
      catch {
        case _: Exception =>
      }
    }
    None
  }

  def loadXlDeployConf(xlDeployConfFile: File):Option[Config] = {
    if (xlDeployConfFile.exists()) {
      val xlDeployConfFileStream = new FileInputStream(xlDeployConfFile)
      try {
        Some(ConfigLoader.loadWithDynamic(xlDeployConfFileStream))
      } finally {
        xlDeployConfFileStream.close()
      }
    } else {
      None
    }
  }

  def getValueOrDefault(config: Config, key: String, defaultValue: AnyRef): AnyRef =
    if(config.hasPath(key))
      config.getAnyRef(key)
    else
      defaultValue
}
