package com.xebialabs.deployit.core.upgrade.configuration

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.core.upgrade.configuration.common.BaseConfigurationUpgrader
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.deployit.util.PropertyUtil
import org.springframework.beans.factory.annotation.Value

import scala.util.{Failure, Success, Try}

class ClusterNodePortConfigurationUpgrader (@Value("${deploy.cluster.akka.remote.artery.canonical.port:25520}")
                                                clusterPort: String) extends BaseConfigurationUpgrader{

  override def destinationFileName: String = "deploy-cluster.yaml"

  override def configurationFileDescription: String = "Cluster config"

  override def upgradeVersion(): Version = Version.valueOf("central-config", "22.3.0")

  override def doUpgrade(): Boolean = Try {
    updateConfiguration()
  } match {
    case Success(_) =>
      logger.debug(s"Moved 'akka remote port' from $destinationFileName to deployit.conf")
      true
    case Failure(exception: Exception) =>
      logger.debug(s"$destinationFileName configuration cannot be moved: " + exception.getMessage)
      false
    case _ =>
      false
  }

  override protected def updateConfiguration(): Unit = {
    val properties = PropertyUtil.readPropertiesFile(deployitConfFile)
    properties.setProperty(ServerConfiguration.KEY_CLUSTER_NODE_PORT, clusterPort)
    PropertyUtil.storePropertiesFile(deployitConfFile, properties)
    deleteCentralConfigurationProperties(Seq("deploy.cluster.akka.remote"))
  }
}

