package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.MetricsProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class MetricsConfigurationUpgrader extends DeployConfUpgrader {
  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.metrics")) {
      createYamlConfiguration(confFile, "xl.metrics", "deploy.metrics", classOf[MetricsProperties])
    }
  }

  override def destinationFileName: String = "deploy-metrics.yaml"

  override def configurationFileDescription: String = "Metrics Configuration"
}
