package com.xebialabs.deployit.core.upgrade.configuration

import com.xebialabs.deployit.core.upgrade.configuration.common.BaseConfigurationUpgrader
import com.xebialabs.deployit.server.api.upgrade.Version

import scala.util.{Failure, Success, Try}

class CachesProperties2310Upgrader extends BaseConfigurationUpgrader {

  override def destinationFileName: String = "deploy-caches.yaml"

  override def configurationFileDescription: String = "Caches config"

  override def upgradeVersion(): Version = Version
    .valueOf("central-config", "23.1.0")

  override def doUpgrade(): Boolean = Try {
    updateConfiguration()
  } match {
    case Success(_) =>
      logger.debug(s"Removed 'deploy.caches.provider-configuration.embedded' and " +
        s"'deploy.caches.ci-pk-path-mapping-cache-configuration' from $destinationFileName")
      true
    case Failure(exception: Exception) =>
      logger.debug(s"$destinationFileName configuration cannot be updated: " + exception.getMessage)
      false
    case _ =>
      false
  }

  override protected def updateConfiguration(): Unit = {
    deleteCentralConfigurationProperties(
      Seq(
        "deploy.caches.provider-configuration.embedded",
        "deploy.caches.ci-pk-path-mapping-cache-configuration.enabled",
        "deploy.caches.ci-pk-path-mapping-cache-configuration.management-enabled",
        "deploy.caches.ci-pk-path-mapping-cache-configuration.statistics-enabled",
        "deploy.caches.ci-pk-path-mapping-cache-configuration.ttl-minutes"
      )
    )
  }
}
