package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.WebSocketsProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class WebSocketsConfigurationUpgrader extends DeployConfUpgrader {
  override protected def xlConfigUpdate(confFile: Config): Unit = {
    val prefix = "xl.deploy.websockets"
    if (confFile.hasPath(prefix)) {
      createYamlConfiguration(confFile, prefix, "deploy.websockets", classOf[WebSocketsProperties])
    }
  }

  override protected def getYamlFileNamesToMove: List[String] = List("xld-websockets.yaml")

  override def destinationFileName: String = "deploy-websockets.yaml"

  override def configurationFileDescription: String = "WebSockets"
}
