package com.xebialabs.deployit.core.upgrade.configuration.common

import java.io.{File, FileWriter}
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator.Feature

import java.nio.file.{Files, StandardCopyOption}
import scala.jdk.CollectionConverters._
import scala.util.Using

trait FileConfigurationUpgrader extends BaseConfigurationUpgrader {

  override protected def updateConfiguration(): Unit = {
    originalFilePaths.foreach { originalFilePath =>
      val sourceFile: File = new File(s"$originalFilePath")
      info(s"Source file location is: $sourceFile")
      if (sourceFile.exists()) {
        info(s"Destination file location is: $destinationFile")
        if(originalFilePath.endsWith(".yaml")) {
          Files.move(sourceFile.toPath, destinationFile.toPath, StandardCopyOption.REPLACE_EXISTING)
        } else {
          Using(new FileWriter(destinationFile)) { fileWriter =>
            val value: Object = new ObjectMapper().readValue(sourceFile, classOf[Object])
            val mapper = new ObjectMapper(new YAMLFactory().disable(Feature.WRITE_DOC_START_MARKER))
            val output: Map[String, Object] = Map(configurationPrefix -> value)
            info(s"Content of $configurationFileDescription during migration is: $output")
            mapper.writeValue(fileWriter, output.asJava)
            sourceFile.delete()
          }
        }
      }
    }

  }

  def originalFilePaths: List[String]

  def configurationPrefix: String
}
