package com.xebialabs.database.anonymizer

import com.xebialabs.database.anonymizer.AnonymizerContants.{DEFAULT_FILE_NAME, DEFAULT_REPORTING_FILE_NAME, DTD_FILE_NAME, REPORTING_DTD_FILE_NAME}
import org.dbunit.database.DatabaseConnection
import org.dbunit.dataset.FilteredDataSet
import org.dbunit.dataset.xml.{FlatDtdDataSet, FlatXmlWriter}
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.io.{File, FileOutputStream}
import scala.jdk.CollectionConverters._

@Service
class ExportService {

  @Autowired
  var repository: DatabaseRepository = _

  @Autowired
  var configuration: AnonymizerConfiguration = _

  def start(isReportingDb: Boolean): Unit = {
    logger.info("Data export has been started. Please wait....")
    var connection: DatabaseConnection = null
    try {
      connection = repository.getDatabaseConnection(isReportingDb)
      val replacementDataSet = getReplacementDataset(connection)
      val fileName = if (isReportingDb) DEFAULT_REPORTING_FILE_NAME else DEFAULT_FILE_NAME
      val datasetWriter = new FlatXmlWriter(new FileOutputStream(new File(fileName)))
      val dtdFileName = if (isReportingDb) REPORTING_DTD_FILE_NAME else DTD_FILE_NAME
      datasetWriter.setDocType(dtdFileName)
      datasetWriter.write(replacementDataSet)
      FlatDtdDataSet.write(replacementDataSet, new FileOutputStream(new File(dtdFileName)))
      logger.info(s"Data export has been successfully finished. You can find $fileName in the server home directory")
    } finally if (connection != null) connection.close()
  }

  private def getReplacementDataset(connection: DatabaseConnection): XldReplacementDataSet = {
    val filter = new AnonymizerDatabaseSequenceFilter(configuration, connection)
    val dataset = new FilteredDataSet(filter, connection.createDataSet)
    val replacementDataSet: XldReplacementDataSet = new XldReplacementDataSet(configuration, dataset)

    configuration.getContentToAnonymize().asScala.foreach { item =>
      replacementDataSet.addReplacementSubstring(item.getKey(), item.getValue())
    }

    replacementDataSet
  }

  private val logger = LoggerFactory.getLogger(classOf[ExportService])
}
