package com.xebialabs.database.anonymizer

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration
import scala.beans.BeanProperty

@Configuration
@ConfigurationProperties(prefix = "deploy.db-anonymizer")
class AnonymizerConfiguration {

  @BeanProperty
  var tablesToNotExport: JList[String] = _

  @BeanProperty
  var tablesToAnonymize: JList[TableColumnValue] = _

  @BeanProperty
  var contentToAnonymize: JList[KeyValue] = _

  @BeanProperty
  var encryptedFieldsToIgnore: JList[EncryptedFieldToIgnore] = _
}

class EncryptedFieldToIgnore {
  @BeanProperty
  var table: String = _

  @BeanProperty
  var column: String = _

  @BeanProperty
  var value: String = _

  @BeanProperty
  var passwordRegex: String = _
}

class TableColumnValue {
  @BeanProperty
  var table: String = _

  @BeanProperty
  var column: String = _

  @BeanProperty
  var value: String = _
}

class KeyValue {
  @BeanProperty
  var key: String = _

  @BeanProperty
  var value: String = _
}

