package com.xebialabs.database.anonymizer

object DatabaseName extends Enumeration {
  type DatabaseName = Value

  val Oracle: Value = Value("oracle")
  val MSSQL: Value = Value("microsoft sql server")
  val POSTGRES: Value = Value("postgresql")
  val MYSQL: Value = Value("mysql")
  val DB2: Value = Value("db2")
  val DEFAULT: Value = Value("default")

  def toValue(value: String): Value = DatabaseName.values.find(_.toString == value).getOrElse(DatabaseName.DEFAULT)
}
