/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade.service;

import com.xebialabs.deployit.core.upgrade.service.BatchUpgraderService;
import com.xebialabs.deployit.engine.spi.artifact.resolution.CannotLocateArtifactException;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.TypeNotFoundException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@Component
@ScalaSignature(bytes="\u0006\u000154Aa\u0002\u0005\u0001+!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003A\u0001\u0011\u0005\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0001\r\"I!\n\u0001a\u0001\u0002\u0004%\ta\u0013\u0005\n#\u0002\u0001\r\u0011!Q!\n\u001dCQ!\u0017\u0001\u0005Bi\u00131\u0004R3gCVdGOQ1uG\",\u0006o\u001a:bI\u0016\u00148+\u001a:wS\u000e,'BA\u0005\u000b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0003\u0007\u0002\u000fU\u0004xM]1eK*\u0011QBD\u0001\u0005G>\u0014XM\u0003\u0002\u0010!\u0005AA-\u001a9m_fLGO\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0006\u000f!!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0011%\u0011q\u0004\u0003\u0002\u0015\u0005\u0006$8\r[+qOJ\fG-\u001a:TKJ4\u0018nY3\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!B:mMRR'\"A\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006a1-\u001b*fa>\u001c\u0018\u000e^8ssB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0004gFd'B\u0001\u0018\u000f\u0003)\u0011X\r]8tSR|'/_\u0005\u0003a-\u0012AbQ5SKB|7/\u001b;pefD#!\u0001\u001a\u0011\u0005MrT\"\u0001\u001b\u000b\u0005U2\u0014AC1o]>$\u0018\r^5p]*\u0011q\u0007O\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI$(A\u0003cK\u0006t7O\u0003\u0002<y\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001>\u0003\ry'oZ\u0005\u0003\u007fQ\u0012\u0011\"Q;u_^L'/\u001a3\u0002\rqJg.\u001b;?)\t\u00115\t\u0005\u0002\u001e\u0001!)\u0001F\u0001a\u0001S!\u00121IM\u0001\nE\u0006$8\r[*ju\u0016,\u0012a\u0012\t\u0003/!K!!\u0013\r\u0003\u0007%sG/A\u0007cCR\u001c\u0007nU5{K~#S-\u001d\u000b\u0003\u0019>\u0003\"aF'\n\u00059C\"\u0001B+oSRDq\u0001\u0015\u0003\u0002\u0002\u0003\u0007q)A\u0002yIE\n!BY1uG\"\u001c\u0016N_3!Q\u0011)1KV,\u0011\u0005M\"\u0016BA+5\u0005\u00151\u0016\r\\;f\u0003\u00151\u0018\r\\;fC\u0005A\u0016\u0001L\u0012|g\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0018va\u001e\u0014\u0018\rZ3CCR\u001c\u0007nU5{K~R\u0014\u0007\r\u0019~\u0003-9W\r\u001e\"bi\u000eD7)[:\u0015\u00071[\u0016\rC\u0003]\r\u0001\u0007Q,A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002_?6\tQ&\u0003\u0002a[\t\u00012+Z1sG\"\u0004\u0016M]1nKR,'o\u001d\u0005\u0006E\u001a\u0001\raY\u0001\u000eE\u0006$8\r[\"bY2\u0014\u0017mY6\u0011\t]!W\fT\u0005\u0003Kb\u0011\u0011BR;oGRLwN\\\u0019)\u0005\u00019\u0007C\u00015l\u001b\u0005I'B\u00016;\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003Y&\u0014\u0011bQ8na>tWM\u001c;")
public class DefaultBatchUpgraderService
implements BatchUpgraderService,
Logging {
    @Autowired
    private final CiRepository ciRepository;
    @Value(value="#{serverConfiguration.upgradeBatchSize?:100}")
    private int batchSize;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultBatchUpgraderService defaultBatchUpgraderService = this;
        synchronized (defaultBatchUpgraderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public void batchSize_$eq(int x$1) {
        this.batchSize = x$1;
    }

    @Override
    public void getBatchCis(SearchParameters query, Function1<SearchParameters, BoxedUnit> batchCallback) {
        Integer count = this.ciRepository.count(query);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Running batch migration on ").append(count).append(" CIs in batches of ").append(this.batchSize()).append(".").toString());
        IntRef pagesIndexed = IntRef.create((int)0);
        int totalPages = (Predef$.MODULE$.Integer2int(count) + this.batchSize() - 1) / this.batchSize();
        while (pagesIndexed.elem < totalPages) {
            SearchParameters params = query.setPage((long)pagesIndexed.elem).setResultsPerPage((long)this.batchSize());
            try {
                Object object;
                try {
                    object = batchCallback.apply((Object)params);
                }
                catch (TypeNotFoundException e) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Skipping page ").append(pagesIndexed$1.elem).append(" due to a missed type.").toString());
                    object = BoxedUnit.UNIT;
                }
                catch (CannotLocateArtifactException e) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Skipping page ").append(pagesIndexed$1.elem).append(" due to missed artifact.").toString());
                    object = BoxedUnit.UNIT;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
            finally {
                ++pagesIndexed.elem;
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Completed batch ").append(pagesIndexed$1.elem).append(" / total: ").append(totalPages).append(".").toString());
            }
        }
    }

    public DefaultBatchUpgraderService(@Autowired CiRepository ciRepository) {
        this.ciRepository = ciRepository;
        Logging.$init$((Logging)this);
    }
}

