/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.Setter;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u00015\u0011abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u00111\"V:feN+'O^5dKB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\f+N,'/U;fe&,7\u000f\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u00031QGMY2UK6\u0004H.\u0019;f+\u0005\t\u0003C\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011\u0019wN]3\u000b\u0005\u0019:\u0013\u0001\u00026eE\u000eT!\u0001K\u0015\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AK\u0001\u0004_J<\u0017B\u0001\u0017$\u00051QEMY2UK6\u0004H.\u0019;f\u0011!q\u0003A!A!\u0002\u0013\t\u0013!\u00046eE\u000e$V-\u001c9mCR,\u0007\u0005\u0003\u00051\u0001\t\u0015\r\u0011b\u00012\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002eA\u00111GN\u0007\u0002i)\u00111!\u000e\u0006\u0003I\u0019I!a\u000e\u001b\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u00033\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\ti$\u000b\u0006\u0002?\u007fA\u00111\u0004\u0001\u0005\u0006ai\u0002\u001dA\r\u0015\u0005\u007f\u0005[E\n\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0019;\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0011\u001e\nQAY3b]NL!AS\"\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A'\u0002\u001d5\f\u0017N\\*rY\u0012K\u0017\r\\3di\"\u0012qh\u0014\t\u0003\u0005BK!!U\"\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B\u0010;\u0001\u0004\t\u0003\u0006\u0002*B\u0017R\u000b\u0013!V\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016D#AU(\t\u000fa\u0003!\u0019!C\u00013\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/F\u0001[!\t92,\u0003\u0002]\t\t)2\u000bS!3kY\u0002\u0016m]:x_J$WI\\2pI\u0016\u0014\bB\u00020\u0001A\u0003%!,\u0001\tqCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3sA!)\u0001\r\u0001C\u0005C\u0006\u00112\r[3dWZ\u000bG.\u001b3Vg\u0016\u0014h.Y7f)\t\u0011\u0007\u000e\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GM\u0001\u0003V]&$\b\"B5`\u0001\u0004Q\u0017\u0001C;tKJt\u0017-\\3\u0011\u0005-\u0014hB\u00017q!\tiG-D\u0001o\u0015\tyG\"\u0001\u0004=e>|GOP\u0005\u0003c\u0012\fa\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000f\u001a\u0005\u0006m\u0002!Ia^\u0001\te\u0016\fG-V:feR\u0011\u0001P \t\u0004Gf\\\u0018B\u0001>e\u0005\u0019y\u0005\u000f^5p]B\u00111\u0004`\u0005\u0003{\n\u0011A\"\u00138uKJt\u0017\r\\+tKJDQ![;A\u0002)Dq!!\u0001\u0001\t\u0003\n\u0019!\u0001\u0003sK\u0006$G\u0003BA\u0003\u0003\u0017\u00012aFA\u0004\u0013\r\tI\u0001\u0002\u0002\u0005+N,'\u000fC\u0003j\u007f\u0002\u0007!\u000eC\u0004\u0002\u0010\u0001!\t%!\u0005\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\u000b\t\f\u0019\"!\u0006\t\r%\fi\u00011\u0001k\u0011\u001d\t9\"!\u0004A\u0002)\f\u0001\u0002]1tg^|'\u000f\u001a\u0005\b\u00037\u0001A\u0011IA\u000f\u00039iw\u000eZ5gsB\u000b7o]<pe\u0012$RAYA\u0010\u0003CAa![A\r\u0001\u0004Q\u0007bBA\u0012\u00033\u0001\rA[\u0001\f]\u0016<\b+Y:to>\u0014H\rC\u0004\u0002\u001c\u0001!\t%a\n\u0015\u000f\t\fI#a\u000b\u0002.!1\u0011.!\nA\u0002)Dq!a\t\u0002&\u0001\u0007!\u000eC\u0004\u00020\u0005\u0015\u0002\u0019\u00016\u0002\u0017=dG\rU1tg^|'\u000f\u001a\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003\u0019!W\r\\3uKR\u0019!-a\u000e\t\r%\f\t\u00041\u0001k\u0011\u001d\tY\u0004\u0001C!\u0003{\taa\u0019:fCR,G#\u00022\u0002@\u0005\u0005\u0003BB5\u0002:\u0001\u0007!\u000eC\u0004\u0002\u0018\u0005e\u0002\u0019\u00016\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005iA.[:u+N,'O\\1nKN$\"!!\u0013\u0011\u000b\u0005-\u0013\u0011\u000b6\u000e\u0005\u00055#bAA(%\u0005!Q\u000f^5m\u0013\u0011\t\u0019&!\u0014\u0003\t1K7\u000f\u001e\u0005\b\u0003\u000b\u0002A\u0011IA,)!\tI%!\u0017\u0002\\\u0005M\u0004BB5\u0002V\u0001\u0007!\u000e\u0003\u0005\u0002^\u0005U\u0003\u0019AA0\u0003\u0019\u0001\u0018mZ5oOB!\u0011\u0011MA8\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014a\u00013u_*!\u0011\u0011NA6\u0003\r\t\u0007/\u001b\u0006\u0004\u0003[2\u0011AB3oO&tW-\u0003\u0003\u0002r\u0005\r$A\u0002)bO&tw\r\u0003\u0005\u0002v\u0005U\u0003\u0019AA<\u0003\u0015y'\u000fZ3s!\u0011\t\t'!\u001f\n\t\u0005m\u00141\r\u0002\t\u001fJ$WM]5oO\"2\u0001!a L\u0003\u001b\u0003B!!!\u0002\n6\u0011\u00111\u0011\u0006\u0004\t\u0006\u0015%bAADO\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\tY)a!\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1mC\t\ty)\u0001\fnC&tGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\u001d\u0001\u00111SAQ\u0003G\u0003B!!&\u0002\u001e6\u0011\u0011q\u0013\u0006\u0004\t\u0006e%bAANO\u000591m\u001c8uKb$\u0018\u0002BAP\u0003/\u0013QaU2pa\u0016\f\u0011\u0002\u001d:pqflu\u000eZ3%\u0005\u0005\u0015\u0016\u0002BAT\u0003S\u000bA\u0002V!S\u000f\u0016#vl\u0011'B'NSA!a+\u0002\u0018\u0006y1kY8qK\u0012\u0004&o\u001c=z\u001b>$W\rK\u0002\u0001\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k;\u0013AC:uKJ,w\u000e^=qK&!\u0011\u0011XAZ\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String SELECT;
    private final String SELECT_NAMES;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private Option<InternalUser> readUser(String username) {
        return ((TraversableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).map((Function1 & Serializable & scala.Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())), Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such user: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authenticate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong credentials supplied for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, username, newPassword, oldPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        Object object = username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username.toLowerCase()})))) : BoxedUnit.UNIT;
        Object object2 = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object3 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)UserSchema$.MODULE$.USERNAME()) : OrderBy$.MODULE$.desc((Selectable)UserSchema$.MODULE$.USERNAME()))) : BoxedUnit.UNIT;
        List names = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new package.MapRowMapper())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()), Buffer$.MODULE$.canBuildFrom())).toList();
        return new ArrayList<String>(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)names));
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String username$4, String newPassword$1, String oldPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
    }
}

