/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ExtendedActorSystem;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.util.TypeConversions$;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u000f\u001f\u00015B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\rq\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000b\u0001\t\u0003\nY\u0003C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002j!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\tY\n\u0001C\u0005\u0003;C\u0011\"a8\u0001#\u0003%I!!\u001b\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u00111\u001f\u0001\u0005B\u0005U\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u00119\u0003\u0001C!\u0005SAqA!\r\u0001\t\u0003\u0012\u0019\u0004C\u0004\u00038\u0001!\tE!\u000f\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!q\t\u0001\u0005B\t%\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003p\u0001!IA!\u001d\u00031M\u000bH\u000eU3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u00111\u0005J\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005\u00152\u0013AB3oO&tWM\u0003\u0002(Q\u0005AA-\u001a9m_fLGO\u0003\u0002*U\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002W\u0005\u00191m\\7\u0004\u0001M1\u0001A\f\u001b9y}\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005\u0001\u0013BA\u001c!\u0005U\u0001VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pef\u0004\"!\u000f\u001e\u000e\u0003yI!a\u000f\u0010\u0003'A+g\u000eZ5oOR\u000b7o[:Rk\u0016\u0014\u0018.Z:\u0011\u0005ej\u0014B\u0001 \u001f\u0005i\u0001VM\u001c3j]\u001e$\u0016m]6NKR\fG-\u0019;b#V,'/[3t!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0003tY\u001a$$NC\u0001E\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001$B\u0005\u001daunZ4j]\u001e\fAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012!\u0013\t\u0003\u0015Nk\u0011a\u0013\u0006\u0003\u00196\u000bAaY8sK*\u0011ajT\u0001\u0005U\u0012\u00147M\u0003\u0002Q#\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013AC:dQ\u0016l\u0017-\u00138g_V\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002 7*\u0011AJJ\u0005\u0003;j\u0013!bU2iK6\f\u0017J\u001c4p\u0003-\u00198\r[3nC&sgm\u001c\u0011\u0002\rqJg.\u001b;?)\t\tg\u000f\u0006\u0002cGB\u0011\u0011\b\u0001\u0005\u0006-\u0016\u0001\u001d\u0001\u0017\u0015\u0005G\u0016|\u0007\u000f\u0005\u0002g[6\tqM\u0003\u0002iS\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)\\\u0017a\u00024bGR|'/\u001f\u0006\u0003Y>\u000bQAY3b]NL!A\\4\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A9\u0002\u00155\f\u0017N\\*dQ\u0016l\u0017\r\u000b\u0002dgB\u0011a\r^\u0005\u0003k\u001e\u0014\u0011\"Q;u_^L'/\u001a3\t\u000b\u001d+\u0001\u0019A%)\tY,w\u000e_\u0011\u0002s\u0006\u0001R.Y5o\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u0003mN\fQ\u0001^1tWN$2!`A\u000e!\u0015q\u0018qAA\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA!\u001e;jY*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014A\u0001T5tiB!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C3yK\u000e,H/[8o\u0015\r\t)\u0002J\u0001\u0004CBL\u0017\u0002BA\r\u0003\u001f\u0011Q\u0002V1tW^KG\u000f\u001b\"m_\u000e\\\u0007bBA\u000f\r\u0001\u0007\u0011qD\u0001\rY>\fGMR;mYN\u0003Xm\u0019\t\u0004_\u0005\u0005\u0012bAA\u0012a\t9!i\\8mK\u0006t\u0017AD:dQ\u0016$W\u000f\\3e)\u0006\u001c8n\u001d\u000b\u0002{\u0006!A/Y:l)\u0019\ti#!\u000f\u0002fA)q&a\f\u00024%\u0019\u0011\u0011\u0007\u0019\u0003\r=\u0003H/[8o!\r)\u0014QG\u0005\u0004\u0003o\u0001#a\u0003)f]\u0012Lgn\u001a+bg.Dq!a\u000f\t\u0001\u0004\ti$\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003\u007f\tyF\u0004\u0003\u0002B\u0005mc\u0002BA\"\u00033rA!!\u0012\u0002X9!\u0011qIA+\u001d\u0011\tI%a\u0015\u000f\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014-\u0003\u0019a$o\\8u}%\t1&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003K\u0019J!a\t\u0013\n\u0007\u0005u#%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005u#\u0005C\u0005\u0002\u001e!\u0001\n\u00111\u0001\u0002 \u0005qA/Y:lI\u0011,g-Y;mi\u0012\u0012TCAA6U\u0011\ty\"!\u001c,\u0005\u0005=\u0004\u0003BA9\u0003sj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001b\u0019\n\t\u0005m\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0003:fC\u0012\u001cV/\\7bef$B!!\f\u0002\u0002\"9\u00111\b\u0006A\u0002\u0005u\u0012\u0001\u0004:fC\u00124U\u000f\u001c7Ta\u0016\u001cG\u0003BA\u0017\u0003\u000fCq!a\u000f\f\u0001\u0004\ti$A\u0007u_B+g\u000eZ5oOR\u000b7o\u001b\u000b\u0005\u0003g\ti\tC\u0004\u0002\u00102\u0001\r!!%\u0002\u0005I\u001c\b\u0003BAJ\u0003/k!!!&\u000b\u0007}\t\u0019!\u0003\u0003\u0002\u001a\u0006U%!\u0003*fgVdGoU3u\u0003U\u0001XM\u001c3j]\u001e$\u0016m]6Ge>l')\u001b8bef$B\"a\r\u0002 \u0006E\u0016\u0011YAk\u00037Dq!a\u000f\u000e\u0001\u0004\t\t\u000b\u0005\u0003\u0002$\u0006-f\u0002BAS\u0003O\u00032!a\u00131\u0013\r\tI\u000bM\u0001\u0007!J,G-\u001a4\n\t\u00055\u0016q\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0006\u0007C\u0004\u000246\u0001\r!!.\u0002\u001bQ\f7o[*qK\u000e\u0014\u0015\u0010^3t!\u0015y\u0013qWA^\u0013\r\tI\f\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004_\u0005u\u0016bAA`a\t!!)\u001f;f\u0011\u001d\t\u0019-\u0004a\u0001\u0003\u000b\fQb]2iK\u0012,H.\u001a3ECR,\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0005i&lWMC\u0002\u0002PF\u000bAA[8eC&!\u00111[Ae\u0005!!\u0015\r^3US6,\u0007bBAl\u001b\u0001\u0007\u0011\u0011\\\u0001\u000eo>\u00148.\u001a:BI\u0012\u0014Xm]:\u0011\u000b=\ny#!)\t\u0013\u0005uW\u0002%AA\u0002\u0005}\u0011!D5t'\u0016tG\u000fV8Rk\u0016,X-A\u0010qK:$\u0017N\\4UCN\\gI]8n\u0005&t\u0017M]=%I\u00164\u0017-\u001e7uIU\nQa\u001d;pe\u0016$b!!\u0010\u0002f\u0006E\bbBAt\u001f\u0001\u0007\u0011\u0011^\u0001\u0005gB,7\r\u0005\u0003\u0002l\u00065X\"\u0001\u0012\n\u0007\u0005=(EA\tUCN\\7\u000b]3dS\u001aL7-\u0019;j_:D\u0011\"a6\u0010!\u0003\u0005\r!!7\u0002\rU\u0004H-\u0019;f)\u0019\t90!@\u0002\u0000B\u0019q&!?\n\u0007\u0005m\bG\u0001\u0003V]&$\bbBA\u001e!\u0001\u0007\u0011Q\b\u0005\b\u0003O\u0004\u0002\u0019AAu\u00031\u0019\b/Z2U_\nKg.\u0019:z)\u0011\t)L!\u0002\t\u000f\u0005\u001d\u0018\u00031\u0001\u0002j\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005Gi!Aa\u0004\u000b\t\tE!1C\u0001\u0005WJLxN\u0003\u0003\u0003\u0016\t]\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0003\u001a\tm\u0011\u0001B1lW\u0006TAA!\b\u0003 \u0005)\u0011\r\u001c;p_*\u0011!\u0011E\u0001\u0003S>LAA!\n\u0003\u0010\t\u00112J]=p\u0003.\\\u0017mU3sS\u0006d\u0017N_3s\u0003-\u0019\u0007.\u00198hK>;h.\u001a:\u0015\r\u0005](1\u0006B\u0017\u0011\u001d\tYd\u0005a\u0001\u0003{AqAa\f\u0014\u0001\u0004\t\t+\u0001\u0005oK^|uO\\3s\u0003Ei\u0017M]6BgN+g\u000e\u001e+p#V,W/\u001a\u000b\u0005\u0003o\u0014)\u0004C\u0004\u0002<Q\u0001\r!!)\u0002\u0011M\u001c\u0007.\u001a3vY\u0016$b!a>\u0003<\tu\u0002bBA\u001e+\u0001\u0007\u0011Q\b\u0005\b\u0005\u007f)\u0002\u0019AAc\u0003\u0011!\u0017\r^3\u0002\r\u0011,G.\u001a;f)\u0011\t9P!\u0012\t\u000f\u0005mb\u00031\u0001\u0002>\u0005\u0001\u0002O]3qCJ,Gk\\#ocV,W/\u001a\u000b\u0005\u0005\u0017\u0012)\u0006\u0005\u0004\u0003N\tE\u00131B\u0007\u0003\u0005\u001fR1!!\u00011\u0013\u0011\u0011\u0019Fa\u0014\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002<]\u0001\r!!\u0010\u0002\u001b\u0015DHO]1diR\u000b7o[%e)\u0011\tiDa\u0017\t\u000f\u0005=\u0005\u00041\u0001\u0002\u0012\u0006!R\r\u001f;sC\u000e$xk\u001c:lKJ\fE\r\u001a:fgN$B!!7\u0003b!9\u0011qR\rA\u0002\u0005E\u0015\u0001F3yiJ\f7\r^*dQ\u0016$W\u000f\\3e\t\u0006$X\r\u0006\u0003\u0002F\n\u001d\u0004bBAH5\u0001\u0007\u0011\u0011S\u0001\u0019Kb$(/Y2u)\u0006\u001c8n\u00159fG&4\u0017nY1uS>tG\u0003BA[\u0005[Bq!a$\u001c\u0001\u0004\t\t*\u0001\u000bfqR\u0014\u0018m\u0019;JgN+g\u000e\u001e+p#V,W/\u001a\u000b\u0005\u0003?\u0011\u0019\bC\u0004\u0002\u0010r\u0001\r!!%)\r\u0001\u00119h\u001cBC!\u0011\u0011IH!!\u000e\u0005\tm$b\u00015\u0003~)\u0019!qP(\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005\u0007\u0013YHA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0011\u0003\u0005\u000f\u000ba#\\1j]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0004\u0001\t-\u0005\u0003\u0002BG\u0005'k!Aa$\u000b\u0007\tEu*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!&\u0003\u0010\nI1i\\7q_:,g\u000e\u001e")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 1) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 8) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x10) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x40) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x400) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs))).asScala().toList() : ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala().groupBy((Function1 & Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.headOption().getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException("No pending task");
            });
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)date -> com.xebialabs.deployit.core.sql.package$.MODULE$.mapDateTime(date)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)list.map((Function1 & Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        })).toList();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (RowMapper)new RowMapper<TaskWithBlock>(this){
            private final /* synthetic */ SqlPendingTaskRepository $outer;

            public TaskWithBlock mapRow(ResultSet rs, int rowNum) {
                return this.$outer.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$3) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$4) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    public PendingTask com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pendingTask = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable)() -> exception.getMessage(), (Function0 & Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoAkkaSerializer serializer() {
        return new KryoAkkaSerializer((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem());
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void markAsSentToQueue(String taskId) {
        this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        SimpleSelectBuilder q = this.schemaInfo().sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.schemaInfo()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$5) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        }
        if (option instanceof Some) {
            PendingTask pendingTask;
            bl = true;
            some = (Some)option;
            TaskWithBlock task = (TaskWithBlock)some.value();
            if (task instanceof PendingTask && (pendingTask = (PendingTask)task).isSentToQueue()) {
                return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            }
        }
        if (!bl) throw new MatchError(option);
        TaskWithBlock task = (TaskWithBlock)some.value();
        return new Success((Object)task);
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

