/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.taskexecution.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.taskexecution.security.TaskWorkerAuthenticationToken;
import com.xebialabs.xlplatform.distribution.RSAUtils;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import scala.Option;

public class TaskWorkerAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String RSA_HEADER = "rsa";
    private static final String DELIMITER = ":";
    private static final int RSA_SIGNATURE_PARTS_SIZE = 6;
    private final TaskExecutionWorkerRepository taskExecutionWorkerRepository;

    protected TaskWorkerAuthenticationFilter(AuthenticationManager authenticationManager, TaskExecutionWorkerRepository taskExecutionWorkerRepository) {
        super("/deployit/**");
        this.taskExecutionWorkerRepository = taskExecutionWorkerRepository;
        this.setAuthenticationManager(authenticationManager);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String rsaHeader = this.getRSAHeader((HttpServletRequest)request);
        if (StringUtils.isEmpty((String)rsaHeader)) {
            chain.doFilter(request, response);
            return;
        }
        String[] rsaSignatureParts = rsaHeader.split(DELIMITER);
        if (rsaSignatureParts.length < 6) {
            chain.doFilter(request, response);
            return;
        }
        if (this.isInvalidRSASignature(rsaSignatureParts, (HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        this.setAuthenticationSuccessHandler((request1, response1, authentication) -> chain.doFilter((ServletRequest)request1, (ServletResponse)response1));
        super.doFilter(request, response, chain);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String rsaHeader = this.getRSAHeader(request);
        if (StringUtils.isEmpty((String)rsaHeader)) {
            return null;
        }
        String[] rsaSignatureParts = rsaHeader.split(DELIMITER);
        if (rsaSignatureParts.length < 6) {
            return null;
        }
        String taskOwner = rsaSignatureParts[0];
        if (this.isInvalidRSASignature(rsaSignatureParts, request)) {
            return null;
        }
        TaskWorkerAuthenticationToken token = new TaskWorkerAuthenticationToken(taskOwner);
        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        try {
            return this.getAuthenticationManager().authenticate((Authentication)token);
        }
        catch (ProviderNotFoundException e) {
            this.logger.error((Object)("No authentication provider found for : " + token.getName() + ". Please check <security:authentication-provider> settings in conf/deployit-security.xml"));
            throw e;
        }
    }

    private boolean isInvalidRSASignature(String[] rsaSignatureParts, HttpServletRequest request) {
        String workerAddress = rsaSignatureParts[1].concat(DELIMITER).concat(rsaSignatureParts[2]).concat(DELIMITER).concat(rsaSignatureParts[3]);
        String nonce = rsaSignatureParts[4].concat(DELIMITER).concat(rsaSignatureParts[5]);
        String rsaSignature = rsaSignatureParts[6];
        String originalRequestURI = request.getQueryString() == null ? request.getRequestURI() : request.getRequestURI() + "?" + request.getQueryString();
        String message = String.join((CharSequence)DELIMITER, Lists.newArrayList((Object[])new String[]{originalRequestURI, request.getMethod(), request.getProtocol(), nonce}));
        Option worker = this.taskExecutionWorkerRepository.getWorkerByAddress(workerAddress);
        if (worker.isDefined() && ((Worker)worker.get()).publicKey() != null) {
            try {
                return !RSAUtils.verify((String)message, (String)rsaSignature, (byte[])((Worker)worker.get()).publicKey());
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to verify RSA Signature", (Throwable)e);
            }
        }
        return true;
    }

    private String getRSAHeader(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().filter(header -> header.equalsIgnoreCase(RSA_HEADER)).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).findFirst().orElse(null);
    }
}

