package ai.digital.deploy.metrics.json

import ai.digital.deploy.metrics.model.UsersCountByCi
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class UsersCountByCiJsonWriter extends AbstractJsonWriter[UsersCountByCi] {

  private val matcher = new TypeMatcher(classOf[UsersCountByCi])

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(usersCountByCi: UsersCountByCi, typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(usersCountByCi).getBytes)


  override protected def writeJson(line: UsersCountByCi, writer: JsonWriter): Unit = {
    writer.array
    writer.`object`()
    writer.key("usersCountByCi").value(line.usersCountByCi)
    writer.endObject()
    writer.endArray
  }
}
