package ai.digital.deploy.metrics.api

import ai.digital.deploy.metrics.model.{DeploymentMetrics, DeploymentMetricsFilter, DeploymentPluginMetrics}
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}

import jakarta.ws.rs.{Consumes, GET, POST, Path, PathParam, Produces}
import jakarta.ws.rs.core.MediaType

@Path("/internal/metrics/")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait DeploymentMetricsService {
  @POST
  @Path("listDeployments")
  def listDeployments(filter: DeploymentMetricsFilter, paging: Paging, order: Ordering): List[DeploymentMetrics]

  @GET
  @Path("getDeploymentsCount")
  def getDeploymentsCount(): Int

  @GET
  @Path("getUsersCountByDeployment/{username}")
  def getUsersCountByDeployment(@PathParam("username") username: String): Int

  @POST
  @Path("getPluginsData")
  def getPluginsData(filter: DeploymentMetricsFilter, paging: Paging, order: Ordering): List[DeploymentPluginMetrics]

  @GET
  @Path("getPluginsCountByDeployment")
  def getPluginsCountByDeployment(): Int
}
