package ai.digital.deploy.metrics.repository

import ai.digital.deploy.metrics.model.{DeploymentMetrics, DeploymentPluginMetrics}
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}


trait DeploymentMetricsRepository {
  def findDeployments(path: String, plugins:List[String], owner: Option[String], startDate:Option[String],
                      taskType: Option[String], paging: Paging, order: Ordering): List[DeploymentMetrics]
  def getDeploymentCount(): Int
  def getUsersCount(owner: String): Int
  def getPluginsData(path: String, plugins:List[String], owner: Option[String], startDate:Option[String],
                     taskType: Option[String], paging: Paging, order: Ordering): List[DeploymentPluginMetrics]
  def getPluginsCount(): Int
}
