/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.ci.YakCheckpointFile;
import com.xebialabs.deployit.plugin.test.yak.ci.YakServer;
import com.xebialabs.deployit.plugin.test.yak.step.DeleteYakFileFromServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.DeployYakFileToServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.FirstTimePauseStep;
import com.xebialabs.deployit.plugin.test.yak.step.UpgradeYakFileOnServerStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedYakCheckpointFile
extends BaseDeployed<YakCheckpointFile, YakServer> {
    private boolean addCheckpoint = true;
    private static final Logger logger = LoggerFactory.getLogger(DeployedYakCheckpointFile.class);

    @Create
    public void deploy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding deploy step");
        DeployYakFileToServerStep deployYakFileToServerStep = new DeployYakFileToServerStep();
        result.addStep((Step)deployYakFileToServerStep);
        if (this.addCheckpoint) {
            result.addCheckpoint((Step)deployYakFileToServerStep, delta);
        }
        result.addStep((Step)new FirstTimePauseStep(60));
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding upgrade step");
        UpgradeYakFileOnServerStep step = new UpgradeYakFileOnServerStep();
        result.addStep((Step)step);
        if (this.addCheckpoint) {
            result.addCheckpoint((Step)step, delta);
        }
        result.addStep((Step)new FirstTimePauseStep(step.getOrder()));
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding undeploy step");
        DeleteYakFileFromServerStep step = new DeleteYakFileFromServerStep();
        result.addStep((Step)step);
        if (this.addCheckpoint) {
            result.addCheckpoint((Step)step, delta);
        }
        result.addStep((Step)new FirstTimePauseStep(step.getOrder()));
    }

    public boolean isAddCheckpoint() {
        return this.addCheckpoint;
    }

    public void setAddCheckpoint(boolean addCheckpoint) {
        this.addCheckpoint = addCheckpoint;
    }
}

