package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.test.yak.step.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedYakFile extends BaseDeployedArtifact<YakFile, YakServer> {

    private static final long serialVersionUID = 1L;

	@Modify @Destroy
    public void stop(DeploymentPlanningContext result) {
	    logger.info("Adding stop artifact");
        result.addStep(new StopDeployedYakFileStep(this));
    }

    @Create @Modify
    public void start(DeploymentPlanningContext result) {
        logger.info("Adding start artifact");
        result.addStep(new StartDeployedYakFileStep(this));
    }

    @Create
    public void deploy(DeploymentPlanningContext result) {
        logger.info("Adding deploy step");
        result.addStep(new DeployYakFileToServerStep(this));
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result) {
        logger.info("Adding upgrade step");
        result.addStep(new UpgradeYakFileOnServerStep(this));
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result) {
        logger.info("Adding undeploy step");
	    result.addStep(new DeleteYakFileFromServerStep(this));
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployedYakFile.class);
}
