package com.xebialabs.deployit.plugin.test.yak.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;

import java.io.File;
import java.util.List;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class StartableContainer extends BaseContainer {

	@Property
	private String tempDir;

	@Property
	private String startFileName;
	
	@Property(description = "Amount of time in milliseconds each step will wait before continuing")
	private int stepDelayTimeInMilliSeconds = 3000;


	@SuppressWarnings("rawtypes")
    @ControlTask(description = "Start the test server.")
	public List<Step> start() {
		Step step = new Step() {

			@Override
			public String getDescription() {
				return "Write a file to tempDir.";
			}

			@Override
			public Result execute(ExecutionContext ctx) throws Exception {
				new File(tempDir, startFileName).createNewFile();
				return Result.Success;
			}
		};
		return Lists.newArrayList(step);
	}
	
	@SuppressWarnings("rawtypes")
    @ControlTask(description = "Stop the test server.")
	public List<Step> stop() {
		Step step = new Step() {

			@Override
			public String getDescription() {
				return "Write a file to tempDir.";
			}

			@Override
			public Result execute(ExecutionContext ctx) throws Exception {
				for (int i = 0; i < stepDelayTimeInMilliSeconds/100; i++) {
					Thread.sleep(100);
				}
				return Result.Success;
			}
		};
		return Lists.newArrayList(step);
	}
	
	@SuppressWarnings("rawtypes")
    @ControlTask(description = "Resume the test server.")
	public List<Step> resume() {
		Step step = new Step() {

			@Override
			public String getDescription() {
				return "Write a file to tempDir.";
			}

			@Override
			public Result execute(ExecutionContext ctx) throws Exception {
				for (int i = 0; i < stepDelayTimeInMilliSeconds/100; i++) {
					Thread.sleep(100);
				}
				for (int i = 0; i < 100; i++){
					ctx.logError("Failed to resume the task.");
				}
				return Result.Fail;
			}
		};
		return Lists.newArrayList(step);
	}
	
	public int getStepDelayTimeInMilliSeconds() {
		return stepDelayTimeInMilliSeconds;
	}

	public void setStepDelayTimeInMilliSeconds(int stepDelayTimeInSeconds) {
		this.stepDelayTimeInMilliSeconds = stepDelayTimeInSeconds;
	}
}
