/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import java.io.File;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class StartableContainer
extends BaseContainer {
    @Property
    private String tempDir;
    @Property
    private String startFileName;
    @Property(description="Amount of time in milliseconds each step will wait before continuing")
    private int stepDelayTimeInMilliSeconds = 3000;

    @ControlTask(description="Start the test server.")
    public List<Step> start() {
        Step step = new Step(){

            public String getDescription() {
                return "Write a file to tempDir.";
            }

            public Step.Result execute(ExecutionContext executionContext) throws Exception {
                new File(StartableContainer.this.tempDir, StartableContainer.this.startFileName).createNewFile();
                return Step.Result.Success;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{step});
    }

    @ControlTask(description="Stop the test server.")
    public List<Step> stop() {
        Step step = new Step(){

            public String getDescription() {
                return "Write a file to tempDir.";
            }

            public Step.Result execute(ExecutionContext executionContext) throws Exception {
                for (int i = 0; i < StartableContainer.this.stepDelayTimeInMilliSeconds / 100; ++i) {
                    Thread.sleep(100L);
                }
                return Step.Result.Success;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{step});
    }

    @ControlTask(description="Resume the test server.")
    public List<Step> resume() {
        Step step = new Step(){

            public String getDescription() {
                return "Write a file to tempDir.";
            }

            public Step.Result execute(ExecutionContext executionContext) throws Exception {
                int n;
                for (n = 0; n < StartableContainer.this.stepDelayTimeInMilliSeconds / 100; ++n) {
                    Thread.sleep(100L);
                }
                for (n = 0; n < 100; ++n) {
                    executionContext.logError("Failed to resume the task.");
                }
                return Step.Result.Fail;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{step});
    }

    public int getStepDelayTimeInMilliSeconds() {
        return this.stepDelayTimeInMilliSeconds;
    }

    public void setStepDelayTimeInMilliSeconds(int n) {
        this.stepDelayTimeInMilliSeconds = n;
    }
}

